/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.files;

import java.io.File;
import java.net.URL;

public enum ShpFileType {
    SHP("shp"),
    DBF("dbf"),
    SHX("shx"),
    PRJ("prj"),
    QIX("qix"),
    FIX("fix"),
    SHP_XML("shp.xml"),
    CPG("cpg");

    public final String extension;
    public final String extensionWithPeriod;
    public final String gzExtensionWithPeriod;

    private ShpFileType(String extension) {
        this.extension = extension.toLowerCase();
        this.extensionWithPeriod = "." + this.extension;
        this.gzExtensionWithPeriod = this.extensionWithPeriod + ".gz";
    }

    public String toBase(File file) {
        String path = file.getPath();
        return this.toBase(path);
    }

    public String toBase(String path) {
        String lcPath = path.toLowerCase();
        if (!lcPath.endsWith(this.extensionWithPeriod) || lcPath.equals(this.extensionWithPeriod)) {
            if (!lcPath.endsWith(this.gzExtensionWithPeriod) || lcPath.equals(this.gzExtensionWithPeriod)) {
                return null;
            }
            int indexOfExtension = lcPath.lastIndexOf(this.gzExtensionWithPeriod);
            return path.substring(0, indexOfExtension);
        }
        int indexOfExtension = lcPath.lastIndexOf(this.extensionWithPeriod);
        return path.substring(0, indexOfExtension);
    }

    public String toBase(URL url) {
        return this.toBase(url.toExternalForm());
    }
}

