/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiapi.search;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.NotImplementedException;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/search"})
@Tag(name="search", description="Search operations")
@Controller(value="search")
public class SearchApi {
    public static final String APPLICATION_RDF_XML = "application/rdf+xml";

    @Operation(summary="Get statistics about a field", description="(experimental) This return facet info for the requested field and provide a list of values.")
    @RequestMapping(produces={"text/html", "application/json", "application/xml", "application/rdf+xml"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void getFieldInfo(@Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response, @Parameter(hidden=true) @RequestHeader(value="Accept", defaultValue="text/html") String accept, @Parameter(hidden=true) @RequestParam Map<String, String> allRequestParams) throws Exception {
        boolean isRdf = APPLICATION_RDF_XML.equals(accept);
        boolean isXml = "application/xml".equals(accept);
        boolean isJson = "application/json".equals(accept);
        if (allRequestParams.get("resultType") == null) {
            allRequestParams.put("resultType", "details");
        }
        allRequestParams.put("fast", isRdf ? "false" : "index");
        response.setHeader("Content-type", (isRdf || isXml || isJson ? accept : "text/html") + ";charset=utf-8");
        Element results = this.query(allRequestParams, request);
        if (isXml) {
            response.getWriter().write(Xml.getString((Element)results));
        } else if (isJson) {
            response.getWriter().write(Xml.getJSON((Element)results));
        } else {
            response.getWriter().write(new XsltResponseWriter(null, "search").withJson("catalog/locales/en-core.json").withJson("catalog/locales/en-search.json").withXml(results).withXsl(isRdf ? "xslt/services/dcat/rdf.xsl" : "xslt/ui-search/search-nojs.xsl").asHtml());
        }
    }

    private Element query(Map<String, String> queryFields, HttpServletRequest request) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
        ServiceContext context = ApiUtils.createServiceContext(request);
        throw new NotImplementedException("Not implemented in ES");
    }
}

