/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing.report;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.geonet.api.processing.report.InfoReport;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SchematronValidationReport;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.SchematronRequirement;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

@JsonPropertyOrder(value={"uuid", "metadata", "validMetadata", "invalidMetadata", "metadataWithWarnings", "validationErrors", "validationWarnings", "numberOfRecords", "numberOfRecordsProcessed", "numberOfValidRecords", "numberOfInvalidRecords", "numberOfRecordsWithValidationWarnings", "numberOfNullRecords", "numberOfRecordsNotEditable", "startIsoDateTime", "endIsoDateTime", "ellapsedTimeInSeconds", "totalTimeInSeconds", "running", "type"})
@JsonIgnoreProperties(value={"errors", "infos", "metadataErrors", "metadataInfos", "numberOfRecordsUnchanged", "numberOfRecordsWithErrors", "numberOfRecordNotFound"})
public class MetadataValidationProcessingReport
extends MetadataProcessingReport {
    protected Map<Integer, InfoReport> validMetadata = new HashMap<Integer, InfoReport>();
    protected Map<Integer, InfoReport> invalidMetadata = new HashMap<Integer, InfoReport>();
    protected Map<Integer, InfoReport> metadataWithWarnings = new HashMap<Integer, InfoReport>();
    protected Map<Integer, List<SchematronValidationReport>> metadataErrors = new HashMap<Integer, List<SchematronValidationReport>>();
    protected Map<Integer, List<SchematronValidationReport>> metadataWarnings = new HashMap<Integer, List<SchematronValidationReport>>();

    public Map<Integer, InfoReport> getValidMetadata() {
        return this.validMetadata;
    }

    public Map<Integer, InfoReport> getInvalidMetadata() {
        return this.invalidMetadata;
    }

    public Map<Integer, InfoReport> getMetadataWithWarnings() {
        return this.metadataWithWarnings;
    }

    public Map<Integer, List<SchematronValidationReport>> getValidationErrors() {
        return this.metadataErrors;
    }

    public Map<Integer, List<SchematronValidationReport>> getValidationWarnings() {
        return this.metadataWarnings;
    }

    public synchronized int getNumberOfValidRecords() {
        return this.validMetadata.size();
    }

    public synchronized int getNumberOfInvalidRecords() {
        return this.invalidMetadata.size();
    }

    public synchronized int getNumberOfRecordsWithValidationWarnings() {
        return this.metadataWithWarnings.size();
    }

    public synchronized void addValidMetadata(int metadataId, String metadataUUID, boolean draft, boolean approved) {
        InfoReport infoReport = new InfoReport("Is valid");
        infoReport.setUuid(metadataUUID);
        infoReport.setDraft(draft);
        infoReport.setApproved(approved);
        this.validMetadata.put(metadataId, infoReport);
    }

    public void addValidMetadata(AbstractMetadata metadata) {
        this.addValidMetadata(metadata.getId(), metadata.getUuid(), this.isMetadataDraft(metadata.getId()), this.isMetadataApproved(metadata.getId()));
    }

    public synchronized void addInvalidMetadata(int metadataId, String metadataUUID, boolean draft, boolean approved) {
        InfoReport infoReport = new InfoReport("Is invalid");
        infoReport.setUuid(metadataUUID);
        infoReport.setDraft(draft);
        infoReport.setApproved(approved);
        this.invalidMetadata.put(metadataId, infoReport);
    }

    public void addInvalidMetadata(AbstractMetadata metadata) {
        this.addInvalidMetadata(metadata.getId(), metadata.getUuid(), this.isMetadataDraft(metadata.getId()), this.isMetadataApproved(metadata.getId()));
    }

    public synchronized void addMetadataWithWarnings(int metadataId, String metadataUUID, boolean draft, boolean approved) {
        InfoReport infoReport = new InfoReport("Has warnings");
        infoReport.setUuid(metadataUUID);
        infoReport.setDraft(draft);
        infoReport.setApproved(approved);
        this.metadataWithWarnings.put(metadataId, infoReport);
    }

    public void addMetadataWithWarnings(AbstractMetadata metadata) {
        this.addMetadataWithWarnings(metadata.getId(), metadata.getUuid(), this.isMetadataDraft(metadata.getId()), this.isMetadataApproved(metadata.getId()));
    }

    public synchronized void addValidationMessage(int metadataId, String metadataUUID, boolean draft, boolean approved, String message, String patternTitle, String schematronName, SchematronRequirement schematronRequirement) {
        Map<Integer, List<SchematronValidationReport>> targetMap = schematronRequirement == SchematronRequirement.REQUIRED ? this.metadataErrors : this.metadataWarnings;
        List schematronValidationReports = targetMap.computeIfAbsent(metadataId, k -> new ArrayList());
        SchematronValidationReport schematronValidationReport = schematronValidationReports.stream().filter(svr -> schematronName.equals(svr.getSchematron())).findFirst().orElseGet(() -> {
            SchematronValidationReport newSchematronValidationReport = new SchematronValidationReport(schematronName);
            schematronValidationReports.add(newSchematronValidationReport);
            return newSchematronValidationReport;
        });
        schematronValidationReport.addMessage(patternTitle, message);
        if (schematronRequirement == SchematronRequirement.REQUIRED && !this.invalidMetadata.containsKey(metadataId)) {
            this.addInvalidMetadata(metadataId, metadataUUID, draft, approved);
        } else if (schematronRequirement == SchematronRequirement.REPORT_ONLY && !this.metadataWithWarnings.containsKey(metadataId)) {
            this.addMetadataWithWarnings(metadataId, metadataUUID, draft, approved);
        }
    }

    public void addValidationMessage(AbstractMetadata metadata, String message, String patternTitle, String schematronName, SchematronRequirement schematronRequirement) {
        this.addValidationMessage(metadata.getId(), metadata.getUuid(), this.isMetadataDraft(metadata.getId()), this.isMetadataApproved(metadata.getId()), message, patternTitle, schematronName, schematronRequirement);
    }

    public synchronized void addAllReportsMatchingRequirement(AbstractMetadata record, Element schemaTronReport, SchematronRequirement requirement) throws JDOMException {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        namespaces.add(Namespace.getNamespace((String)"geonet", (String)"http://www.fao.org/geonetwork"));
        namespaces.add(Namespace.getNamespace((String)"svrl", (String)"http://purl.oclc.org/dsdl/svrl"));
        if (SchematronRequirement.REQUIRED.equals((Object)requirement)) {
            List xsdErrors = Xml.selectNodes((Element)schemaTronReport, (String)"geonet:xsderrors/geonet:error/geonet:message[normalize-space(.) != '']", namespaces);
            for (Object xsdError : xsdErrors) {
                String message = Xml.selectString((Element)((Element)xsdError), (String)"normalize-space(.)", namespaces);
                this.addValidationMessage(record, message, null, "XSD", SchematronRequirement.REQUIRED);
            }
        }
        List schematronReports = Xml.selectNodes((Element)schemaTronReport, (String)String.format("geonet:schematronerrors/geonet:report[@geonet:required = '%s']", requirement.toString()), namespaces);
        for (Object schematronReportObject : schematronReports) {
            Element schematronReport = (Element)schematronReportObject;
            String schematronName = schematronReport.getAttributeValue("rule", (Namespace)namespaces.get(0));
            List patterns = Xml.selectNodes((Element)schematronReport, (String)"svrl:schematron-output/svrl:active-pattern", namespaces);
            for (Object patternObject : patterns) {
                Element patternElem = (Element)patternObject;
                String patternTitle = patternElem.getAttributeValue("name");
                List messages = Xml.selectNodes((Element)patternElem, (String)"svrl:fired-rule/svrl:failed-assert/svrl:text[normalize-space(.) != '']", namespaces);
                for (Object messageObject : messages) {
                    String message = Xml.selectString((Element)((Element)messageObject), (String)"normalize-space(.)", namespaces);
                    this.addValidationMessage(record, message, patternTitle, schematronName, requirement);
                }
            }
            List messages = Xml.selectNodes((Element)schematronReport, (String)"geonet:schematronVerificationError[normalize-space(.) != '']", namespaces);
            for (Object messageObject : messages) {
                String message = Xml.selectString((Element)((Element)messageObject), (String)"normalize-space(.)", namespaces);
                this.addValidationMessage(record, message, null, schematronName, SchematronRequirement.REQUIRED);
            }
        }
    }
}

