/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh.services;

import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.kernel.oaipmh.OaiPmhService;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.oaipmh.requests.AbstractRequest;
import org.fao.oaipmh.responses.AbstractResponse;
import org.fao.oaipmh.responses.IdentifyResponse;

public class Identify
implements OaiPmhService {
    @Override
    public String getVerb() {
        return "Identify";
    }

    @Override
    public AbstractResponse execute(AbstractRequest request, ServiceContext context) throws Exception {
        IdentifyResponse res = new IdentifyResponse();
        SettingInfo si = context.getBean(SettingInfo.class);
        String baseUrl = si.getSiteUrl() + context.getBaseUrl() + "/srv/" + context.getService();
        res.setRepositoryName(si.getSiteName());
        res.setBaseUrl(baseUrl);
        res.setEarliestDateStamp(this.getEarliestDS(context));
        res.setDeletedRecord(IdentifyResponse.DeletedRecord.NO);
        res.setGranularity(IdentifyResponse.Granularity.LONG);
        res.addAdminEmail(si.getFeedbackEmail());
        return res;
    }

    private ISODate getEarliestDS(ServiceContext context) {
        Metadata oldestByChangeDate = context.getBean(MetadataRepository.class).findOldestByChangeDate();
        if (oldestByChangeDate == null) {
            return new ISODate();
        }
        return oldestByChangeDate.getDataInfo().getChangeDate();
    }
}

