/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintPairwise;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class DisjointConstraint
extends ConstraintPairwise {
    public DisjointConstraint(Node value) {
        super(value, SHACL.DisjointConstraintComponent);
    }

    @Override
    public void validate(ValidationContext vCxt, Shape shape, Node focusNode, Path path, Set<Node> pathNodes, Set<Node> compareNodes) {
        boolean allPassed = true;
        for (Node vn : pathNodes) {
            boolean passed = true;
            if (compareNodes.contains(vn)) {
                String msg = this.toString() + ": not disjoint: " + ShLib.displayStr(vn) + " is in " + compareNodes;
                passed = false;
                allPassed = false;
                vCxt.reportEntry(msg, shape, focusNode, path, vn, this);
            }
            if (passed) continue;
            vCxt.notifyValidationListener(() -> this.makeEventSinglePathNode(vCxt, shape, focusNode, path, vn, compareNodes, false));
        }
        if (allPassed) {
            vCxt.notifyValidationListener(() -> this.makeEvent(vCxt, shape, focusNode, path, pathNodes, compareNodes, true));
        }
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compact(out, nodeFmt, "disjoint", this.value);
    }

    public String toString() {
        return "Disjoint[" + ShLib.displayStr(this.value) + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, 1);
    }
}

