/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetModelSnapshotUpgradeStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetModelSnapshotUpgradeStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    private final String jobId;
    private final String snapshotId;
    public static final Endpoint<GetModelSnapshotUpgradeStatsRequest, GetModelSnapshotUpgradeStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetModelSnapshotUpgradeStatsRequest, GetModelSnapshotUpgradeStatsResponse>("es/ml.get_model_snapshot_upgrade_stats", request -> "GET", request -> {
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            buf.append("/_upgrade");
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("jobId", request.jobId);
            params.put("snapshotId", request.snapshotId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetModelSnapshotUpgradeStatsResponse._DESERIALIZER);

    private GetModelSnapshotUpgradeStatsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.snapshotId = ApiTypeHelper.requireNonNull(builder.snapshotId, this, "snapshotId");
    }

    public static GetModelSnapshotUpgradeStatsRequest of(Function<Builder, ObjectBuilder<GetModelSnapshotUpgradeStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetModelSnapshotUpgradeStatsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        private String jobId;
        private String snapshotId;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetModelSnapshotUpgradeStatsRequest build() {
            this._checkSingleUse();
            return new GetModelSnapshotUpgradeStatsRequest(this);
        }
    }
}

