/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TokenCountProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Double nullValue;
    @Nullable
    private final Boolean enablePositionIncrements;
    public static final JsonpDeserializer<TokenCountProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TokenCountProperty::setupTokenCountPropertyDeserializer);

    private TokenCountProperty(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.boost = builder.boost;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
        this.enablePositionIncrements = builder.enablePositionIncrements;
    }

    public static TokenCountProperty of(Function<Builder, ObjectBuilder<TokenCountProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.TokenCount;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final Double nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Boolean enablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "token_count");
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.doubleValue());
        }
        if (this.enablePositionIncrements != null) {
            generator.writeKey("enable_position_increments");
            generator.write(this.enablePositionIncrements.booleanValue());
        }
    }

    protected static void setupTokenCountPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::nullValue, JsonpDeserializer.doubleDeserializer(), "null_value");
        op.add(Builder::enablePositionIncrements, JsonpDeserializer.booleanDeserializer(), "enable_position_increments");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TokenCountProperty> {
        @Nullable
        private String analyzer;
        @Nullable
        private Double boost;
        @Nullable
        private Boolean index;
        @Nullable
        private Double nullValue;
        @Nullable
        private Boolean enablePositionIncrements;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder nullValue(@Nullable Double value) {
            this.nullValue = value;
            return this;
        }

        public final Builder enablePositionIncrements(@Nullable Boolean value) {
            this.enablePositionIncrements = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TokenCountProperty build() {
            this._checkSingleUse();
            return new TokenCountProperty(this);
        }
    }
}

