/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class TopMetrics
implements JsonpSerializable {
    private final List<FieldValue> sort;
    private final Map<String, FieldValue> metrics;
    public static final JsonpDeserializer<TopMetrics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopMetrics::setupTopMetricsDeserializer);

    private TopMetrics(Builder builder) {
        this.sort = ApiTypeHelper.unmodifiableRequired(builder.sort, (Object)this, "sort");
        this.metrics = ApiTypeHelper.unmodifiableRequired(builder.metrics, (Object)this, "metrics");
    }

    public static TopMetrics of(Function<Builder, ObjectBuilder<TopMetrics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FieldValue> sort() {
        return this.sort;
    }

    public final Map<String, FieldValue> metrics() {
        return this.metrics;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (FieldValue fieldValue : this.sort) {
                fieldValue.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metrics)) {
            generator.writeKey("metrics");
            generator.writeStartObject();
            for (Map.Entry entry : this.metrics.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((FieldValue)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTopMetricsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "sort");
        op.add(Builder::metrics, JsonpDeserializer.stringMapDeserializer(FieldValue._DESERIALIZER), "metrics");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TopMetrics> {
        private List<FieldValue> sort;
        private Map<String, FieldValue> metrics;

        public final Builder sort(List<FieldValue> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(FieldValue value, FieldValue ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(String value, String ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (String v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(long value, long ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (long v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(double value, double ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (double v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(boolean value, boolean ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
            for (boolean v : values) {
                fieldValues.add(FieldValue.of(v));
            }
            this.sort = Builder._listAddAll(this.sort, fieldValues);
            return this;
        }

        public final Builder sort(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.sort(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        public final Builder metrics(Map<String, FieldValue> map) {
            this.metrics = Builder._mapPutAll(this.metrics, map);
            return this;
        }

        public final Builder metrics(String key, FieldValue value) {
            this.metrics = Builder._mapPut(this.metrics, key, value);
            return this;
        }

        public final Builder metrics(String key, Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.metrics(key, fn.apply(new FieldValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TopMetrics build() {
            this._checkSingleUse();
            return new TopMetrics(this);
        }
    }
}

