/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tdigest;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.tdigest.Centroid;
import org.elasticsearch.tdigest.IntAVLTree;

final class AVLGroupTree
extends AbstractCollection<Centroid> {
    private double centroid;
    private long count;
    private double[] centroids;
    private long[] counts;
    private long[] aggregatedCounts;
    private final IntAVLTree tree = new IntAVLTree(){

        @Override
        protected void resize(int newCapacity) {
            super.resize(newCapacity);
            AVLGroupTree.this.centroids = Arrays.copyOf(AVLGroupTree.this.centroids, newCapacity);
            AVLGroupTree.this.counts = Arrays.copyOf(AVLGroupTree.this.counts, newCapacity);
            AVLGroupTree.this.aggregatedCounts = Arrays.copyOf(AVLGroupTree.this.aggregatedCounts, newCapacity);
        }

        @Override
        protected void merge(int node) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void copy(int node) {
            AVLGroupTree.this.centroids[node] = AVLGroupTree.this.centroid;
            AVLGroupTree.this.counts[node] = AVLGroupTree.this.count;
        }

        @Override
        protected int compare(int node) {
            if (AVLGroupTree.this.centroid < AVLGroupTree.this.centroids[node]) {
                return -1;
            }
            return 1;
        }

        @Override
        protected void fixAggregates(int node) {
            super.fixAggregates(node);
            AVLGroupTree.this.aggregatedCounts[node] = AVLGroupTree.this.counts[node] + AVLGroupTree.this.aggregatedCounts[this.left(node)] + AVLGroupTree.this.aggregatedCounts[this.right(node)];
        }
    };

    AVLGroupTree() {
        this.centroids = new double[this.tree.capacity()];
        this.counts = new long[this.tree.capacity()];
        this.aggregatedCounts = new long[this.tree.capacity()];
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    public int prev(int node) {
        return this.tree.prev(node);
    }

    public int next(int node) {
        return this.tree.next(node);
    }

    public double mean(int node) {
        return this.centroids[node];
    }

    public long count(int node) {
        return this.counts[node];
    }

    public void add(double centroid, long count) {
        this.centroid = centroid;
        this.count = count;
        this.tree.add();
    }

    @Override
    public boolean add(Centroid centroid) {
        this.add(centroid.mean(), centroid.count());
        return true;
    }

    public void update(int node, double centroid, long count) {
        this.centroid = centroid;
        this.count = count;
        this.tree.update(node);
    }

    public int floor(double centroid) {
        int floor = 0;
        int node = this.tree.root();
        while (node != 0) {
            int cmp = Double.compare(centroid, this.mean(node));
            if (cmp <= 0) {
                node = this.tree.left(node);
                continue;
            }
            floor = node;
            node = this.tree.right(node);
        }
        return floor;
    }

    public int floorSum(long sum) {
        int floor = 0;
        int node = this.tree.root();
        while (node != 0) {
            int left = this.tree.left(node);
            long leftCount = this.aggregatedCounts[left];
            if (leftCount <= sum) {
                floor = node;
                sum -= leftCount + this.count(node);
                node = this.tree.right(node);
                continue;
            }
            node = this.tree.left(node);
        }
        return floor;
    }

    public int first() {
        return this.tree.first(this.tree.root());
    }

    public int last() {
        return this.tree.last(this.tree.root());
    }

    public long headSum(int node) {
        int left = this.tree.left(node);
        long sum = this.aggregatedCounts[left];
        int n = node;
        int p = this.tree.parent(node);
        while (p != 0) {
            if (n == this.tree.right(p)) {
                int leftP = this.tree.left(p);
                sum += this.counts[p] + this.aggregatedCounts[leftP];
            }
            n = p;
            p = this.tree.parent(n);
        }
        return sum;
    }

    @Override
    public Iterator<Centroid> iterator() {
        return this.iterator(this.first());
    }

    private Iterator<Centroid> iterator(final int startNode) {
        return new Iterator<Centroid>(){
            int nextNode;
            {
                this.nextNode = startNode;
            }

            @Override
            public boolean hasNext() {
                return this.nextNode != 0;
            }

            @Override
            public Centroid next() {
                Centroid next = new Centroid(AVLGroupTree.this.mean(this.nextNode), AVLGroupTree.this.count(this.nextNode));
                this.nextNode = AVLGroupTree.this.tree.next(this.nextNode);
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read-only iterator");
            }
        };
    }

    public long sum() {
        return this.aggregatedCounts[this.tree.root()];
    }

    void checkBalance() {
        this.tree.checkBalance(this.tree.root());
    }

    void checkAggregates() {
        this.checkAggregates(this.tree.root());
    }

    private void checkAggregates(int node) {
        assert (this.aggregatedCounts[node] == this.counts[node] + this.aggregatedCounts[this.tree.left(node)] + this.aggregatedCounts[this.tree.right(node)]);
        if (node != 0) {
            this.checkAggregates(this.tree.left(node));
            this.checkAggregates(this.tree.right(node));
        }
    }
}

