/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.callback;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.manager.callback.LifecycleCallbackSupport;
import ro.isdc.wro.util.StopWatch;

public class PerformanceLoggerCallback
extends LifecycleCallbackSupport {
    private static final Logger LOG = LoggerFactory.getLogger(PerformanceLoggerCallback.class);
    private static final String SHORT_SUMMARY = "=====Performance Logger Statistics==============";
    private StopWatch watch;

    private StopWatch getWatch() {
        if (this.watch == null) {
            this.watch = new StopWatch(){

                @Override
                public String shortSummary() {
                    return PerformanceLoggerCallback.SHORT_SUMMARY;
                }
            };
        }
        return this.watch;
    }

    @Override
    public void onBeforeModelCreated() {
        this.resetWatch();
        this.getWatch().start("model creation");
    }

    private void resetWatch() {
        this.watch = null;
    }

    @Override
    public void onAfterModelCreated() {
        this.stopWatchIfRunning();
    }

    @Override
    public void onBeforeMerge() {
        this.getWatch().start("PreProcessing");
    }

    @Override
    public void onAfterMerge() {
        this.stopWatchIfRunning();
        this.getWatch().start("PostProcessing");
    }

    @Override
    public void onProcessingComplete() {
        this.stopWatchIfRunning();
        if (this.getWatch().getTaskCount() > 0) {
            LOG.debug(this.getWatch().prettyPrint());
        }
    }

    private void stopWatchIfRunning() {
        if (this.getWatch().isRunning()) {
            this.getWatch().stop();
        }
    }
}

