/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.languages;

import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;

public class FeedbackLanguages {
    private Locale[] supportedLocales;
    private String translationFollowsText;
    @Autowired
    SettingManager settingManager;

    @PostConstruct
    public void init() {
        this.updateSupportedLocales();
        this.updateTranslationFollowsText();
    }

    public void updateSupportedLocales() {
        String systemFeedbackLanguages = this.getSettingsValue("system/feedback/languages");
        if (StringUtils.isBlank((String)systemFeedbackLanguages)) {
            this.supportedLocales = null;
            return;
        }
        this.supportedLocales = (Locale[])Arrays.stream(systemFeedbackLanguages.split(",")).map(String::trim).map(Locale::new).filter(this::isValidLocale).toArray(Locale[]::new);
    }

    public void updateTranslationFollowsText() {
        this.translationFollowsText = this.getSettingsValue("system/feedback/translationFollowsText");
    }

    public Locale[] getLocales(Locale fallbackLocale) {
        if (this.supportedLocales == null || this.supportedLocales.length < 1) {
            return new Locale[]{fallbackLocale};
        }
        return this.supportedLocales;
    }

    public String getTranslationFollowsText() {
        return this.translationFollowsText;
    }

    private boolean isValidLocale(Locale locale) {
        Boolean isValid;
        try {
            isValid = locale.getLanguage().equals("eng") || ResourceBundle.getBundle("org.fao.geonet.api.Messages", locale).getLocale().getLanguage().equals(locale.getLanguage());
        }
        catch (MissingResourceException e) {
            isValid = false;
        }
        if (!isValid.booleanValue()) {
            String localeLanguage;
            try {
                localeLanguage = locale.getISO3Language();
            }
            catch (MissingResourceException e) {
                localeLanguage = locale.getLanguage();
            }
            Log.warning((String)"geonetwork.feedbacklanguages", (Object)("Locale '" + localeLanguage + "'  is invalid or missing message bundles. Ensure feedback locales are correct."));
        }
        return isValid;
    }

    private String getSettingsValue(String settingName) {
        return this.settingManager.getValue(settingName);
    }
}

