/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v20;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Logger;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataCategory;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.AbstractAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.geonet.v20.GeonetParams;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.repository.MetadataCategoryRepository;
import org.fao.geonet.repository.specification.MetadataCategorySpecs;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;

public class Aligner
extends AbstractAligner<GeonetParams> {
    private final AtomicBoolean cancelMonitor;
    private Logger log;
    private XmlRequest req;
    private DataManager dataMan;
    private IMetadataManager metadataManager;
    private ServiceContext context;
    private CategoryMapper localCateg;
    private UUIDMapper localUuids;
    private HarvestResult result;

    public Aligner(AtomicBoolean cancelMonitor, Logger log, XmlRequest req, GeonetParams params, DataManager dm, IMetadataManager metadataManager, ServiceContext sc, CategoryMapper cm) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.req = req;
        this.params = params;
        this.dataMan = dm;
        this.metadataManager = metadataManager;
        this.context = sc;
        this.localCateg = cm;
    }

    public HarvestResult align(Element result, String siteId) throws Exception {
        this.log.info("Start of alignment for site-id=" + siteId);
        this.result = new HarvestResult();
        this.result.siteId = siteId;
        List mdList = result.getChildren("metadata");
        this.localUuids = new UUIDMapper((IMetadataUtils)this.context.getBean(IMetadataUtils.class), siteId);
        for (String uuid : this.localUuids.getUUIDs()) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            if (this.exists(mdList, uuid)) continue;
            String id = this.localUuids.getID(uuid);
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Removing old metadata with id=" + id);
            }
            this.metadataManager.deleteMetadata(this.context, id);
            this.metadataManager.flush();
            ++this.result.locallyRemoved;
        }
        for (Element aMdList : mdList) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            Element info = aMdList.getChild("info", Edit.NAMESPACE);
            String remoteId = info.getChildText("id");
            String remoteUuid = info.getChildText("uuid");
            String schema = info.getChildText("schema");
            String changeDate = info.getChildText("changeDate");
            ++this.result.totalMetadata;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Obtained remote id=" + remoteId + ", changeDate=" + changeDate);
            }
            if (!this.dataMan.existsSchema(schema)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  - Skipping unsupported schema : " + schema);
                }
                ++this.result.schemaSkipped;
                continue;
            }
            String id = this.dataMan.getMetadataId(remoteUuid);
            if (id == null) {
                id = this.addMetadata(info);
            } else {
                this.updateMetadata(siteId, info, id);
            }
            this.metadataManager.flush();
            if (id == null) continue;
            this.dataMan.indexMetadata(id, true);
        }
        this.log.info("End of alignment for site-id=" + siteId);
        return this.result;
    }

    private String addMetadata(Element info) throws Exception {
        Element md;
        String remoteId = info.getChildText("id");
        String remoteUuid = info.getChildText("uuid");
        String schema = info.getChildText("schema");
        String createDate = info.getChildText("createDate");
        String changeDate = info.getChildText("changeDate");
        if (this.log.isDebugEnabled()) {
            this.log.debug("  - Adding metadata with remote id=" + remoteId);
        }
        if ((md = this.getRemoteMetadata(this.req, remoteId)) == null) {
            this.log.warning("  - Cannot get metadata (possibly bad XML) with remote id=" + remoteId);
            return null;
        }
        Metadata metadata = new Metadata();
        metadata.setUuid(remoteUuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.METADATA).setChangeDate(new ISODate(changeDate)).setCreateDate(new ISODate(createDate));
        metadata.getSourceInfo().setSourceId(((GeonetParams)this.params).getUuid()).setOwner(Integer.valueOf(this.getOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((GeonetParams)this.params).getUuid());
        try {
            metadata.getSourceInfo().setGroupOwner(Integer.valueOf(((GeonetParams)this.params).getOwnerIdGroup()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List categories = info.getChildren("category");
        this.addCategories((AbstractMetadata)metadata, categories);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        ++this.result.addedMetadata;
        this.addPrivileges(id);
        return id;
    }

    private void addCategories(AbstractMetadata metadata, List<Element> categ) throws Exception {
        MetadataCategoryRepository categoryRepository = (MetadataCategoryRepository)this.context.getBean(MetadataCategoryRepository.class);
        Collection catNames = Lists.transform(categ, (Function)new Function<Element, String>(){

            @Nullable
            public String apply(@Nonnull Element input) {
                String catName = input.getText();
                return Aligner.this.localCateg.getID(catName);
            }
        });
        catNames = Collections2.filter((Collection)catNames, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input != null;
            }
        });
        List categories = categoryRepository.findAll(MetadataCategorySpecs.hasCategoryNameIn((Collection)catNames));
        if (this.log.isDebugEnabled()) {
            this.log.debug("    - Setting categories : " + categories);
        }
        metadata.getCategories().addAll(categories);
    }

    private void addPrivileges(String id) throws Exception {
        this.dataMan.setOperation(this.context, id, "0", "0");
        this.dataMan.setOperation(this.context, id, "1", "0");
    }

    private void updateMetadata(String siteId, Element info, String id) throws Exception {
        String remoteId = info.getChildText("id");
        String remoteUuid = info.getChildText("uuid");
        String changeDate = info.getChildText("changeDate");
        if (this.localUuids.getID(remoteUuid) == null) {
            this.log.error("  - Warning! The remote uuid '" + remoteUuid + "' does not belong to site '" + siteId + "'");
            this.log.error("     - The site id of this metadata has been changed.");
            this.log.error("     - The metadata update will be skipped.");
            ++this.result.uuidSkipped;
        } else {
            this.updateMetadata(id, remoteId, remoteUuid, changeDate);
            this.updateCategories(id, info);
        }
    }

    private void updateMetadata(String id, String remoteId, String remoteUuid, String changeDate) throws Exception {
        String date = this.localUuids.getChangeDate(remoteUuid);
        if (!this.updateCondition(date, changeDate)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - XML not changed to local metadata with id=" + id);
            }
            ++this.result.unchangedMetadata;
        } else {
            Element md;
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Updating local metadata with id=" + id);
            }
            if ((md = this.getRemoteMetadata(this.req, remoteId)) == null) {
                this.log.warning("  - Cannot get metadata (possibly bad XML) with remote id=" + remoteId);
            } else {
                boolean validate = false;
                boolean ufo = false;
                String language = this.context.getLanguage();
                this.metadataManager.updateMetadata(this.context, id, md, validate, ufo, language, changeDate, false, IndexingMode.none);
                ++this.result.updatedMetadata;
            }
        }
    }

    private void updateCategories(String id, Element info) throws Exception {
        List catList = info.getChildren("category");
        Collection locCateg = this.dataMan.getCategories(id);
        for (MetadataCategory el : locCateg) {
            int catId = el.getId();
            String catName = el.getName();
            if (this.existsCategory(catList, catName)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Unsetting category : " + catName);
            }
            this.dataMan.unsetCategory(this.context, id, catId);
        }
        for (Element categ : catList) {
            String catName = categ.getAttributeValue("name");
            String catId = this.localCateg.getID(catName);
            if (catId == null || this.dataMan.isCategorySet(id, Integer.valueOf(catId).intValue())) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Setting category : " + catName);
            }
            this.dataMan.setCategory(this.context, id, catId);
        }
    }

    private boolean existsCategory(List<Element> catList, String name) {
        for (Element aCatList : catList) {
            Element categ = aCatList;
            String catName = categ.getText();
            if (!catName.equals(name)) continue;
            return true;
        }
        return false;
    }

    private Element getRemoteMetadata(XmlRequest req, String id) throws Exception {
        req.setAddress(((GeonetParams)this.params).getServletPath() + "/srv/en/xml.metadata.get");
        req.clearParams();
        req.addParam("id", (Object)id);
        try {
            Element md = req.execute();
            Element info = md.getChild("info", Edit.NAMESPACE);
            if (info != null) {
                info.detach();
            }
            try {
                Integer groupIdVal = null;
                if (StringUtils.isNotEmpty((String)((GeonetParams)this.params).getOwnerIdGroup())) {
                    groupIdVal = this.getGroupOwner();
                }
                ((GeonetParams)this.params).getValidate().validate(this.dataMan, this.context, md, groupIdVal);
                return (Element)md.detach();
            }
            catch (Exception e) {
                this.log.info("Ignoring invalid metadata: " + id);
                ++this.result.doesNotValidate;
                return md;
            }
        }
        catch (Exception e) {
            this.log.warning("Cannot retrieve remote metadata with id:" + id);
            this.log.warning(" (C) Error is : " + e.getMessage());
            return null;
        }
    }

    private boolean exists(List<Element> mdList, String uuid) {
        for (Element aMdList : mdList) {
            Element elInfo = aMdList.getChild("info", Edit.NAMESPACE);
            if (!uuid.equals(elInfo.getChildText("uuid"))) continue;
            return true;
        }
        return false;
    }

    private boolean updateCondition(String localDate, String remoteDate) {
        ISODate remote = new ISODate(remoteDate);
        ISODate local = new ISODate(localDate);
        return remote.timeDifferenceInSeconds(local) > 0L;
    }
}

