/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders.roles;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geoserver.security.jwtheaders.JwtConfiguration;

public class RoleConverter {
    Map<String, List<String>> conversionMap;
    boolean externalNameMustBeListed;

    public RoleConverter(JwtConfiguration config) {
        this.conversionMap = config.getRoleConverterAsMap();
        this.externalNameMustBeListed = config.isOnlyExternalListedRoles();
    }

    public List<String> convert(List<String> externalRoles) {
        ArrayList<String> result = new ArrayList<String>();
        if (externalRoles == null) {
            return result;
        }
        for (String externalRole : externalRoles) {
            List<String> gsRole = this.conversionMap.get(externalRole);
            if (gsRole == null && !this.externalNameMustBeListed) {
                result.add(externalRole);
                continue;
            }
            if (gsRole == null) continue;
            result.addAll(gsRole);
        }
        return result;
    }
}

