/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.search.KeywordsSearcher;
import org.fao.geonet.kernel.search.keyword.KeywordRelation;
import org.fao.geonet.kernel.search.keyword.KeywordSort;
import org.fao.geonet.kernel.search.keyword.SortDirection;
import org.jdom.Content;
import org.jdom.Element;

public class GetKeywordByIdAsConcept
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        String sThesaurusName = Util.getParam((Element)params, (String)"thesaurus");
        String uri = Util.getParam((Element)params, (String)"id", null);
        String lang = Util.getParam((Element)params, (String)"lang", (String)context.getLanguage());
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        ThesaurusManager thesaurusMan = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
        Thesaurus the = thesaurusMan.getThesaurusByName(sThesaurusName);
        String langForThesaurus = the.getIsoLanguageMapper().iso639_2_to_iso639_1(lang);
        KeywordsSearcher searcher = null;
        Element root = null;
        if (uri == null) {
            root = new Element("descKeys");
        } else {
            searcher = new KeywordsSearcher(context, (ThesaurusFinder)thesaurusMan);
            KeywordBean kb = null;
            kb = searcher.searchById(uri, sThesaurusName, new String[]{langForThesaurus, "eng"});
            if (kb == null) {
                root = new Element("descKeys");
            } else {
                String[] relations;
                root = KeywordsSearcher.toRawElement((Element)new Element("descKeys"), (KeywordBean)kb);
                for (String request : relations = new String[]{"narrower", "broader", "related"}) {
                    searcher = new KeywordsSearcher(context, (ThesaurusFinder)thesaurusMan);
                    KeywordRelation reqType = request.equals("broader") ? KeywordRelation.NARROWER : (request.equals("narrower") ? KeywordRelation.BROADER : KeywordRelation.RELATED);
                    searcher.searchForRelated(params, reqType, KeywordSort.defaultLabelSorter((SortDirection)SortDirection.DESC), new String[]{lang, "eng"});
                    Element keywordType = new Element(request);
                    for (KeywordBean kbr : searcher.getResults()) {
                        keywordType.addContent((Content)kbr.toElement(context.getLanguage(), new String[]{"eng"}));
                    }
                    root.addContent((Content)keywordType);
                }
            }
        }
        return root;
    }
}

