/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import jeeves.JeevesCacheManager;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.regions.ThesaurusRequest;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.kernel.rdf.QueryBuilder;
import org.fao.geonet.kernel.rdf.ResultInterpreter;
import org.fao.geonet.kernel.rdf.Selectors;
import org.fao.geonet.kernel.region.Region;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.region.Request;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryResultsTable;

public class ThesaurusBasedRegionsDAO
extends RegionsDAO {
    private static final ResultInterpreter<String> CATEGORY_ID_READER = new ResultInterpreter<String>(){

        public String createFromRow(Thesaurus thesaurus, QueryResultsTable resultTable, int rowIndex) {
            Value value = resultTable.getValue(rowIndex, 0);
            return value.toString();
        }
    };
    private static final String CATEGORY_ID_CACHE_KEY = "CATEGORY_ID_CACHE_KEY";
    private final Set<String> localesToLoad;
    private final WeakHashMap<String, Map<String, String>> categoryIdMap = new WeakHashMap();
    private final GeometryFactory factory = new GeometryFactory();
    private String thesaurusName = "external.place.regions";

    public ThesaurusBasedRegionsDAO(Set<String> localesToLoad) {
        this.localesToLoad = Collections.unmodifiableSet(localesToLoad);
    }

    public Request createSearchRequest(ServiceContext context) throws Exception {
        Thesaurus thesaurus = this.getThesaurus(context);
        return new ThesaurusRequest(context, this.categoryIdMap, this.localesToLoad, thesaurus);
    }

    public synchronized void setThesaurusName(String thesaurusName) {
        super.clearCaches();
        this.thesaurusName = thesaurusName;
    }

    private synchronized Thesaurus getThesaurus(ServiceContext context) throws Exception {
        ThesaurusManager th = (ThesaurusManager)context.getBean(ThesaurusManager.class);
        Thesaurus regions = th.getThesaurusByName(this.thesaurusName);
        if (regions != null) {
            return regions;
        }
        Set all = th.getThesauriMap().entrySet();
        for (Map.Entry entry : all) {
            if (!((String)entry.getKey()).contains("regions")) continue;
            return (Thesaurus)entry.getValue();
        }
        return null;
    }

    public Geometry getGeom(ServiceContext context, String id, boolean simplified, CoordinateReferenceSystem projection) throws Exception {
        Region region = this.createSearchRequest(context).id(id).get();
        if (region == null) {
            return null;
        }
        Geometry geometry = this.factory.toGeometry((Envelope)region.getBBox(projection));
        geometry.setUserData((Object)region.getBBox().getCoordinateReferenceSystem());
        return geometry;
    }

    public Collection<String> getRegionCategoryIds(final ServiceContext context) throws Exception {
        return (Collection)JeevesCacheManager.findInTenSecondCache((String)CATEGORY_ID_CACHE_KEY, (Callable)new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() throws Exception {
                Thesaurus thesaurus = ThesaurusBasedRegionsDAO.this.getThesaurus(context);
                if (thesaurus != null) {
                    QueryBuilder queryBuilder = QueryBuilder.builder().interpreter(CATEGORY_ID_READER);
                    queryBuilder.distinct(true);
                    queryBuilder.select(Selectors.BROADER, true);
                    return queryBuilder.build().execute(thesaurus);
                }
                return null;
            }
        });
    }

    public List<KeywordBean> getRegionTopConcepts(final ServiceContext context) throws Exception {
        return (List)JeevesCacheManager.findInTenSecondCache((String)(CATEGORY_ID_CACHE_KEY + context.getLanguage() + this.thesaurusName), (Callable)new Callable<List<KeywordBean>>(){

            @Override
            public List<KeywordBean> call() throws Exception {
                Thesaurus thesaurus = ThesaurusBasedRegionsDAO.this.getThesaurus(context);
                if (thesaurus != null) {
                    return thesaurus.getTopConcepts(new String[]{context.getLanguage(), "eng"});
                }
                return null;
            }
        });
    }
}

