/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.extent;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.map.WMTSMapLayer;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.StreamingRenderer;

public class WMTSClient {
    WMTSLayer layer;
    TileMatrixSet tileMatrixSet;
    WebMapTileServer wmts;

    public WMTSClient(URL url, String layerName, String matrixSet) throws Exception {
        this.wmts = new WebMapTileServer(url);
        this.layer = this.wmts.getCapabilities().getLayer(layerName);
        if (this.layer == null) {
            throw new Exception("no such layer as:" + layerName);
        }
        this.tileMatrixSet = this.wmts.getCapabilities().getMatrixSet(matrixSet);
        if (this.tileMatrixSet == null) {
            throw new Exception("no such tileMatrixSet:" + matrixSet);
        }
    }

    public BufferedImage createImage(double xmin, double ymin, double xmax, double ymax, int imageWidth, int imageHeight) throws IOException {
        ReferencedEnvelope envelope = new ReferencedEnvelope(xmin, xmax, ymin, ymax, this.tileMatrixSet.getCoordinateReferenceSystem());
        return this.createImage(envelope, imageWidth, imageHeight);
    }

    public BufferedImage createImage(double xmin, double ymin, double xmax, double ymax, int imageWidth, int imageHeight, String crsText) throws Exception {
        ReferencedEnvelope envelope = new ReferencedEnvelope(xmin, xmax, ymin, ymax, CRS.decode((String)crsText));
        ReferencedEnvelope envelope2 = envelope.transform(this.tileMatrixSet.getCoordinateReferenceSystem(), false);
        return this.createImage(envelope2, imageWidth, imageHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createImage(ReferencedEnvelope envelope, int imageWidth, int imageHeight) throws IOException {
        WMTSMapLayer mapLayer = new WMTSMapLayer(this.wmts, (Layer)this.layer, this.tileMatrixSet.getCoordinateReferenceSystem());
        MapContent mapContent = null;
        try {
            mapContent = new MapContent();
            mapContent.addLayer((org.geotools.map.Layer)mapLayer);
            mapContent.setViewport(new MapViewport(envelope));
            BufferedImage image = new BufferedImage(imageWidth, imageHeight, 1);
            Rectangle imageBounds = new Rectangle(0, 0, imageWidth, imageHeight);
            Graphics2D gr = image.createGraphics();
            gr.setPaint(Color.WHITE);
            gr.fill(imageBounds);
            StreamingRenderer renderer = new StreamingRenderer();
            renderer.setMapContent(mapContent);
            renderer.paint(gr, imageBounds, envelope);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (mapContent != null) {
                mapContent.dispose();
            }
        }
    }
}

