/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import org.json.JSONException;
import org.json.JSONWriter;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.DefaultExtraPage;
import org.mapfish.print.config.layout.DynamicImagesPage;
import org.mapfish.print.config.layout.ExtraPage;
import org.mapfish.print.config.layout.LastPage;
import org.mapfish.print.config.layout.MainPage;
import org.mapfish.print.config.layout.MetaData;
import org.mapfish.print.config.layout.TitlePage;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class Layout {
    private MetaData metaData;
    private TitlePage titlePage;
    private MainPage mainPage;
    private DynamicImagesPage dynamicImagesPage;
    private DefaultExtraPage extraPage;
    private LastPage lastPage;
    private String outputFilename;

    public void render(PJsonObject params, RenderingContext context) throws DocumentException {
        if (this.metaData != null) {
            this.metaData.render(params, context);
        }
        if (this.titlePage != null && params.optBool("includeTitlePage", true)) {
            this.titlePage.render(params, context);
        }
        this.renderExtraPages("beforeMainPage", params, context);
        if (this.mainPage != null) {
            PJsonArray pages = params.getJSONArray("pages");
            for (int i = 0; i < pages.size(); ++i) {
                PJsonObject cur = pages.getJSONObject(i);
                this.mainPage.render(cur, context);
            }
        }
        this.renderExtraPages("beforeLastPage", params, context);
        if (this.lastPage != null && params.optBool("includeLastPage", true)) {
            this.lastPage.render(params, context);
        }
        this.renderExtraPages("afterLastPage", params, context);
    }

    private void renderExtraPages(String position, PJsonObject params, RenderingContext context) throws DocumentException {
        for (ExtraPage extraPage : context.getExtraPages()) {
            if (!position.equals(extraPage.getRenderOn())) continue;
            extraPage.render(params, context);
        }
        if (this.extraPage != null && position.equals(this.extraPage.getRenderOn()) && params.optBool("includeExtraPage", true)) {
            this.extraPage.render(params, context);
        }
        if (this.dynamicImagesPage != null && position.equals(this.dynamicImagesPage.getRenderOn())) {
            this.dynamicImagesPage.render(params, context);
        }
    }

    public void setTitlePage(TitlePage titlePage) {
        this.titlePage = titlePage;
    }

    public MainPage getMainPage() {
        return this.mainPage;
    }

    public void setMainPage(MainPage mainPage) {
        this.mainPage = mainPage;
    }

    public void setLastPage(LastPage lastPage) {
        this.lastPage = lastPage;
    }

    public void setMetaData(MetaData metaData) {
        this.metaData = metaData;
    }

    public DynamicImagesPage getDynamicImagesPage() {
        return this.dynamicImagesPage;
    }

    public void setDynamicImagesPage(DynamicImagesPage dynamicImagesPage) {
        this.dynamicImagesPage = dynamicImagesPage;
    }

    public DefaultExtraPage getExtraPage() {
        return this.extraPage;
    }

    public void setExtraPage(DefaultExtraPage extraPage) {
        this.extraPage = extraPage;
    }

    public Rectangle getFirstPageSize(RenderingContext context, PJsonObject params) {
        if (this.titlePage != null) {
            return this.titlePage.getPageSizeRect(context, params);
        }
        return this.mainPage.getPageSizeRect(context, params);
    }

    public void printClientConfig(JSONWriter json) throws JSONException {
        this.mainPage.printClientConfig(json);
    }

    public boolean isSupportLegacyReader() {
        return this.metaData != null && this.metaData.isSupportLegacyReader();
    }

    public void validate() {
        if (this.mainPage == null) {
            throw new InvalidValueException("mainPage", "null");
        }
        this.mainPage.validate();
        if (this.titlePage != null) {
            this.titlePage.validate();
        }
        if (this.lastPage != null) {
            this.lastPage.validate();
        }
    }

    public String getOutputFilename() {
        return this.outputFilename;
    }

    public void setOutputFilename(String outputFilename) {
        this.outputFilename = outputFilename;
    }
}

