/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.AggregationUsageService;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class ValuesSourceRegistry {
    private final AggregationUsageService usageService;
    private final Map<RegistryKey<?>, Map<ValuesSourceType, ?>> aggregatorRegistry;

    private static Map<RegistryKey<?>, Map<ValuesSourceType, ?>> copyMap(Map<RegistryKey<?>, List<Map.Entry<ValuesSourceType, ?>>> mutableMap) {
        Map.Entry[] copiedEntries = new Map.Entry[mutableMap.size()];
        int i = 0;
        for (Map.Entry<RegistryKey<?>, List<Map.Entry<ValuesSourceType, ?>>> entry : mutableMap.entrySet()) {
            RegistryKey<?> topKey = entry.getKey();
            List<Map.Entry<ValuesSourceType, ?>> values = entry.getValue();
            Map.Entry newEntry = Map.entry(topKey, Map.ofEntries(values.toArray(new Map.Entry[0])));
            copiedEntries[i++] = newEntry;
        }
        return Map.ofEntries(copiedEntries);
    }

    public ValuesSourceRegistry(Map<RegistryKey<?>, List<Map.Entry<ValuesSourceType, ?>>> aggregatorRegistry, AggregationUsageService usageService) {
        this.aggregatorRegistry = ValuesSourceRegistry.copyMap(aggregatorRegistry);
        this.usageService = usageService;
    }

    public <T> T getAggregator(RegistryKey<T> registryKey, ValuesSourceConfig valuesSourceConfig) {
        if (registryKey != null && this.aggregatorRegistry.containsKey(registryKey)) {
            Object supplier = this.aggregatorRegistry.get(registryKey).get(valuesSourceConfig.valueSourceType());
            if (supplier == null) {
                RuntimeException unmappedException = valuesSourceConfig.valueSourceType().getUnregisteredException(valuesSourceConfig.getDescription() + " is not supported for aggregation [" + registryKey.getName() + "]");
                assert (unmappedException != null) : "Value source type [" + valuesSourceConfig.valueSourceType() + "] did not return a valid exception for aggregation [" + registryKey.getName() + "]";
                throw unmappedException;
            }
            return (T)supplier;
        }
        throw new AggregationExecutionException("Unregistered Aggregation [" + (registryKey != null ? registryKey.getName() : "unknown aggregation") + "]");
    }

    public AggregationUsageService getUsageService() {
        return this.usageService;
    }

    public static final class RegistryKey<T> {
        private final String name;
        private final Class<T> supplierType;

        public RegistryKey(String name, Class<T> supplierType) {
            this.name = Objects.requireNonNull(name);
            this.supplierType = Objects.requireNonNull(supplierType);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegistryKey that = (RegistryKey)o;
            return this.name.equals(that.name) && this.supplierType.equals(that.supplierType);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.supplierType);
        }
    }

    public static class Builder {
        private final AggregationUsageService.Builder usageServiceBuilder;
        private final Map<RegistryKey<?>, List<Map.Entry<ValuesSourceType, ?>>> aggregatorRegistry = new HashMap();

        public Builder() {
            this.usageServiceBuilder = new AggregationUsageService.Builder();
        }

        public <T> void register(RegistryKey<T> registryKey, ValuesSourceType valuesSourceType, T aggregatorSupplier, boolean registerUsage) {
            if (!this.aggregatorRegistry.containsKey(registryKey)) {
                this.aggregatorRegistry.put(registryKey, new ArrayList());
            }
            this.aggregatorRegistry.get(registryKey).add(new AbstractMap.SimpleEntry<ValuesSourceType, T>(valuesSourceType, aggregatorSupplier));
            if (registerUsage) {
                this.registerUsage(registryKey.getName(), valuesSourceType);
            }
        }

        public <T> void register(RegistryKey<T> registryKey, List<ValuesSourceType> valuesSourceTypes, T aggregatorSupplier, boolean registerUsage) {
            for (ValuesSourceType valuesSourceType : valuesSourceTypes) {
                this.register(registryKey, valuesSourceType, aggregatorSupplier, registerUsage);
            }
        }

        public void registerUsage(String aggregationName, ValuesSourceType valuesSourceType) {
            this.usageServiceBuilder.registerAggregationUsage(aggregationName, valuesSourceType.typeName());
        }

        public void registerUsage(String aggregationName) {
            this.usageServiceBuilder.registerAggregationUsage(aggregationName);
        }

        public ValuesSourceRegistry build() {
            return new ValuesSourceRegistry(this.aggregatorRegistry, this.usageServiceBuilder.build());
        }
    }
}

