/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.DocReader;
import org.elasticsearch.script.field.EmptyField;
import org.elasticsearch.script.field.Field;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xcontent.XContentType;

public abstract class DocBasedScript {
    protected final DocReader docReader;

    public DocBasedScript(DocReader docReader) {
        this.docReader = docReader;
    }

    public Field<?> field(String fieldName) {
        if (this.docReader == null) {
            return new EmptyField(fieldName);
        }
        return this.docReader.field(fieldName);
    }

    public Stream<Field<?>> fields(String fieldGlob) {
        if (this.docReader == null) {
            return Stream.empty();
        }
        return this.docReader.fields(fieldGlob);
    }

    public void setDocument(int docID) {
        if (this.docReader != null) {
            this.docReader.setDocument(docID);
        }
    }

    public Map<String, Object> docAsMap() {
        if (this.docReader == null) {
            return Collections.emptyMap();
        }
        return this.docReader.docAsMap();
    }

    public Supplier<Source> source() {
        if (this.docReader == null) {
            return () -> Source.empty(XContentType.JSON);
        }
        return this.docReader.source();
    }

    public Map<String, ScriptDocValues<?>> getDoc() {
        if (this.docReader == null) {
            return Collections.emptyMap();
        }
        return this.docReader.doc();
    }
}

