/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherIndexFieldData;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

public class SourceValueFetcherSortedBinaryIndexFieldData
extends SourceValueFetcherIndexFieldData<SortedBinaryDocValues> {
    protected SourceValueFetcherSortedBinaryIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedBinaryDocValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
    }

    @Override
    public SourceValueFetcherSortedBinaryLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        return new SourceValueFetcherSortedBinaryLeafFieldData(this.toScriptFieldFactory, context, this.valueFetcher, this.sourceProvider);
    }

    public static class SourceValueFetcherSortedBinaryLeafFieldData
    extends SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<SortedBinaryDocValues> {
        public SourceValueFetcherSortedBinaryLeafFieldData(ToScriptFieldFactory<SortedBinaryDocValues> toScriptFieldFactory, LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            super(toScriptFieldFactory, leafReaderContext, valueFetcher, sourceProvider);
        }

        @Override
        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory(new SourceValueFetcherSortedBinaryDocValues(this.leafReaderContext, this.valueFetcher, this.sourceProvider), name);
        }
    }

    public static class SourceValueFetcherSortedBinaryDocValues
    extends SortedBinaryDocValues
    implements SourceValueFetcherIndexFieldData.ValueFetcherDocValues {
        private final LeafReaderContext leafReaderContext;
        private final ValueFetcher valueFetcher;
        private final SourceProvider sourceProvider;
        private final SortedSet<BytesRef> values;
        private Iterator<BytesRef> iterator;

        public SourceValueFetcherSortedBinaryDocValues(LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            this.leafReaderContext = leafReaderContext;
            this.valueFetcher = valueFetcher;
            this.sourceProvider = sourceProvider;
            this.values = new TreeSet<BytesRef>();
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            this.values.clear();
            Source source = this.sourceProvider.getSource(this.leafReaderContext, doc);
            for (Object object : this.valueFetcher.fetchValues(source, doc, Collections.emptyList())) {
                this.values.add(new BytesRef((CharSequence)object.toString()));
            }
            this.iterator = this.values.iterator();
            return !this.values.isEmpty();
        }

        @Override
        public int docValueCount() {
            return this.values.size();
        }

        @Override
        public BytesRef nextValue() throws IOException {
            assert (this.iterator.hasNext());
            return this.iterator.next();
        }
    }

    public static class Builder
    extends SourceValueFetcherIndexFieldData.Builder<SortedBinaryDocValues> {
        public Builder(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedBinaryDocValues> toScriptFieldFactory) {
            super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
        }

        public SourceValueFetcherSortedBinaryIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SourceValueFetcherSortedBinaryIndexFieldData(this.fieldName, this.valuesSourceType, this.valueFetcher, this.sourceProvider, this.toScriptFieldFactory);
        }
    }
}

