/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene99.Lucene99Codec;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.codec.LegacyPerFieldMapperCodec;
import org.elasticsearch.index.codec.PerFieldMapperCodec;
import org.elasticsearch.index.codec.zstd.Zstd814StoredFieldsFormat;
import org.elasticsearch.index.mapper.MapperService;

public class CodecService {
    public static final FeatureFlag ZSTD_STORED_FIELDS_FEATURE_FLAG = new FeatureFlag("zstd_stored_fields");
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String LEGACY_DEFAULT_CODEC = "legacy_default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LEGACY_BEST_COMPRESSION_CODEC = "legacy_best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";

    public CodecService(@Nullable MapperService mapperService, BigArrays bigArrays) {
        HashMap<String, Object> codecs = new HashMap<String, Object>();
        LegacyPerFieldMapperCodec legacyBestSpeedCodec = new LegacyPerFieldMapperCodec(Lucene99Codec.Mode.BEST_SPEED, mapperService, bigArrays);
        if (ZSTD_STORED_FIELDS_FEATURE_FLAG.isEnabled()) {
            codecs.put(DEFAULT_CODEC, (Object)new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_SPEED, mapperService, bigArrays));
        } else {
            codecs.put(DEFAULT_CODEC, (Object)legacyBestSpeedCodec);
        }
        codecs.put(LEGACY_DEFAULT_CODEC, (Object)legacyBestSpeedCodec);
        LegacyPerFieldMapperCodec legacyBestCompressionCodec = new LegacyPerFieldMapperCodec(Lucene99Codec.Mode.BEST_COMPRESSION, mapperService, bigArrays);
        if (ZSTD_STORED_FIELDS_FEATURE_FLAG.isEnabled()) {
            codecs.put(BEST_COMPRESSION_CODEC, (Object)new PerFieldMapperCodec(Zstd814StoredFieldsFormat.Mode.BEST_COMPRESSION, mapperService, bigArrays));
        } else {
            codecs.put(BEST_COMPRESSION_CODEC, (Object)legacyBestCompressionCodec);
        }
        codecs.put(LEGACY_BEST_COMPRESSION_CODEC, (Object)legacyBestCompressionCodec);
        codecs.put(LUCENE_DEFAULT_CODEC, Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName((String)codec));
        }
        this.codecs = Map.copyOf(codecs);
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }
}

