/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.bootstrap.StartupException;
import org.elasticsearch.common.inject.CreationException;

@Plugin(name="consoleException", category="Converter")
@ConverterKeys(value={"consoleException"})
public class ConsoleThrowablePatternConverter
extends ThrowablePatternConverter {
    private final boolean enabled;

    private ConsoleThrowablePatternConverter(String[] options, Configuration config, boolean enabled) {
        super("ConsoleThrowablePatternConverter", "throwable", options, config);
        this.enabled = enabled;
    }

    public static ConsoleThrowablePatternConverter newInstance(Configuration config, String[] options) {
        return ConsoleThrowablePatternConverter.newInstance(config, options, BootstrapInfo.getConsole() != null);
    }

    static ConsoleThrowablePatternConverter newInstance(Configuration config, String[] options, boolean enabled) {
        return new ConsoleThrowablePatternConverter(options, config, enabled);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        Throwable error = event.getThrown();
        if (!this.enabled || error == null) {
            super.format(event, toAppendTo);
            return;
        }
        if (error instanceof StartupException) {
            StartupException e = (StartupException)error;
            error = e.getCause();
            toAppendTo.append("\n\nElasticsearch failed to startup normally.\n\n");
        }
        ConsoleThrowablePatternConverter.appendShortStacktrace(error, toAppendTo);
        if (error instanceof CreationException) {
            toAppendTo.append("There were problems initializing Guice. See log for more details.");
        } else {
            toAppendTo.append("\n\nSee logs for more details.\n");
        }
    }

    private static void appendShortStacktrace(Throwable error, StringBuilder toAppendTo) {
        toAppendTo.append(error.getClass().getName());
        toAppendTo.append(": ");
        toAppendTo.append(error.getMessage());
        StackTraceElement[] stacktrace = error.getStackTrace();
        int len = Math.min(stacktrace.length, 5);
        for (int i = 0; i < len; ++i) {
            toAppendTo.append("\n\tat ");
            toAppendTo.append(stacktrace[i].toString());
        }
    }
}

