/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperBase;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.JsonException;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class SimpleJsonpMapper
extends JsonpMapperBase {
    public static SimpleJsonpMapper INSTANCE = new SimpleJsonpMapper(true);
    public static SimpleJsonpMapper INSTANCE_REJECT_UNKNOWN_FIELDS = new SimpleJsonpMapper(false);
    private static final Map<Type, JsonpSerializer<?>> serializers = new HashMap();
    private static final Map<Type, JsonpDeserializer<?>> deserializers = new HashMap();
    private final boolean ignoreUnknownFields;

    public SimpleJsonpMapper(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public SimpleJsonpMapper() {
        this(true);
    }

    @Override
    public <T> JsonpMapper withAttribute(String name, T value) {
        return new SimpleJsonpMapper(this.ignoreUnknownFields).addAttribute(name, value);
    }

    @Override
    public boolean ignoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    @Override
    public JsonProvider jsonProvider() {
        return JsonpUtils.provider();
    }

    @Override
    public <T> void serialize(T value, JsonGenerator generator) {
        JsonpSerializer<Object> serializer = SimpleJsonpMapper.findSerializer(value);
        if (serializer == null) {
            JsonpSerializer<?> serializer_ = serializers.get(value.getClass());
            serializer = serializer_;
        }
        if (serializer == null) {
            serializer = this.getDefaultSerializer(value);
        }
        if (serializer == null) {
            throw new JsonException("Cannot find a serializer for type " + value.getClass().getName() + ". Consider using a full-featured JsonpMapper");
        }
        serializer.serialize(value, generator, this);
    }

    @Override
    protected <T> JsonpDeserializer<T> getDefaultDeserializer(Type type) {
        JsonpDeserializer<?> deserializer = deserializers.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        throw new JsonException("Cannot find a deserializer for type " + type.getTypeName() + ". Consider using a full-featured JsonpMapper");
    }

    protected <T> JsonpSerializer<T> getDefaultSerializer(T value) {
        return null;
    }

    static {
        serializers.put((Type)((Object)String.class), (value, generator, mapper) -> generator.write(value));
        serializers.put((Type)((Object)Boolean.class), (value, generator, mapper) -> generator.write(value.booleanValue()));
        serializers.put(Boolean.TYPE, (value, generator, mapper) -> generator.write(value.booleanValue()));
        serializers.put((Type)((Object)Integer.class), (value, generator, mapper) -> generator.write(value.intValue()));
        serializers.put(Integer.TYPE, (value, generator, mapper) -> generator.write(value.intValue()));
        serializers.put((Type)((Object)Long.class), (value, generator, mapper) -> generator.write(value.longValue()));
        serializers.put(Long.TYPE, (value, generator, mapper) -> generator.write(value.longValue()));
        serializers.put((Type)((Object)Float.class), (value, generator, mapper) -> generator.write((double)value.floatValue()));
        serializers.put(Float.TYPE, (value, generator, mapper) -> generator.write((double)value.floatValue()));
        serializers.put((Type)((Object)Double.class), (value, generator, mapper) -> generator.write(value.doubleValue()));
        serializers.put(Double.TYPE, (value, generator, mapper) -> generator.write(value.doubleValue()));
        deserializers.put((Type)((Object)String.class), JsonpDeserializer.stringDeserializer());
        deserializers.put((Type)((Object)Boolean.class), JsonpDeserializer.booleanDeserializer());
        deserializers.put(Boolean.TYPE, JsonpDeserializer.booleanDeserializer());
        deserializers.put((Type)((Object)Integer.class), JsonpDeserializer.integerDeserializer());
        deserializers.put(Integer.TYPE, JsonpDeserializer.integerDeserializer());
        deserializers.put((Type)((Object)Long.class), JsonpDeserializer.longDeserializer());
        deserializers.put(Long.TYPE, JsonpDeserializer.longDeserializer());
        deserializers.put((Type)((Object)Float.class), JsonpDeserializer.floatDeserializer());
        deserializers.put(Float.TYPE, JsonpDeserializer.floatDeserializer());
        deserializers.put((Type)((Object)Double.class), JsonpDeserializer.doubleDeserializer());
        deserializers.put(Double.TYPE, JsonpDeserializer.doubleDeserializer());
    }
}

