/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.list;

import bak.pcj.AbstractCharCollection;
import bak.pcj.CharCollection;
import bak.pcj.CharIterator;
import bak.pcj.hash.DefaultCharHashFunction;
import bak.pcj.list.CharList;
import bak.pcj.list.CharListIterator;
import bak.pcj.util.Exceptions;

public abstract class AbstractCharList
extends AbstractCharCollection
implements CharList {
    protected AbstractCharList() {
    }

    public boolean add(char v) {
        this.add(this.size(), v);
        return true;
    }

    public void add(int index, char v) {
        Exceptions.unsupported("add");
    }

    public boolean addAll(int index, CharCollection c) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        CharIterator i = c.iterator();
        boolean result = i.hasNext();
        while (i.hasNext()) {
            this.add(index, i.next());
            ++index;
        }
        return result;
    }

    public int indexOf(char c) {
        return this.indexOf(0, c);
    }

    public int indexOf(int index, char c) {
        CharListIterator i = this.listIterator(index);
        while (i.hasNext()) {
            if (i.next() != c) continue;
            return i.previousIndex();
        }
        return -1;
    }

    public CharIterator iterator() {
        return this.listIterator();
    }

    public int lastIndexOf(char c) {
        CharListIterator i = this.listIterator(this.size());
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public int lastIndexOf(int index, char c) {
        CharListIterator i = this.listIterator(index);
        while (i.hasPrevious()) {
            if (i.previous() != c) continue;
            return i.nextIndex();
        }
        return -1;
    }

    public CharListIterator listIterator() {
        return this.listIterator(0);
    }

    public CharListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            Exceptions.indexOutOfBounds(index, 0, this.size());
        }
        return new CharListIterator(index){
            private int ptr;
            private int lptr;
            private final /* synthetic */ int val$index;
            {
                this.ptr = this.val$index = val$index;
                this.lptr = -1;
            }

            public boolean hasNext() {
                return this.ptr < AbstractCharList.this.size();
            }

            public char next() {
                if (this.ptr == AbstractCharList.this.size()) {
                    Exceptions.endOfIterator();
                }
                this.lptr = this.ptr++;
                return AbstractCharList.this.get(this.lptr);
            }

            public void remove() {
                if (this.lptr == -1) {
                    Exceptions.noElementToRemove();
                }
                AbstractCharList.this.removeElementAt(this.lptr);
                if (this.lptr < this.ptr) {
                    --this.ptr;
                }
                this.lptr = -1;
            }

            public void add(char v) {
                AbstractCharList.this.add(this.ptr++, v);
                this.lptr = -1;
            }

            public boolean hasPrevious() {
                return this.ptr > 0;
            }

            public int nextIndex() {
                return this.ptr;
            }

            public char previous() {
                if (this.ptr == 0) {
                    Exceptions.startOfIterator();
                }
                --this.ptr;
                this.lptr = this.ptr;
                return AbstractCharList.this.get(this.ptr);
            }

            public int previousIndex() {
                return this.ptr - 1;
            }

            public void set(char v) {
                if (this.lptr == -1) {
                    Exceptions.noElementToSet();
                }
                AbstractCharList.this.set(this.lptr, v);
            }
        };
    }

    public char removeElementAt(int index) {
        Exceptions.unsupported("removeElementAt");
        throw new RuntimeException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CharList)) {
            return false;
        }
        CharListIterator i1 = this.listIterator();
        CharListIterator i2 = ((CharList)obj).listIterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next() == i2.next()) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public int hashCode() {
        int h = 1;
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            h = 31 * h + DefaultCharHashFunction.INSTANCE.hash(i.next());
        }
        return h;
    }

    public abstract char set(int var1, char var2);

    public abstract char get(int var1);
}

