/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;

class JdkCloseableByteBuffer
implements CloseableByteBuffer {
    private final Arena arena = Arena.ofConfined();
    final MemorySegment segment;
    private final ByteBuffer bufferView;

    JdkCloseableByteBuffer(int len) {
        this.segment = this.arena.allocate(len);
        this.bufferView = this.segment.asByteBuffer();
    }

    @Override
    public ByteBuffer buffer() {
        return this.bufferView;
    }

    @Override
    public void close() {
        this.arena.close();
    }
}

