/*
 * Decompiled with CFR 0.152.
 */
package v280;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.fao.geonet.DatabaseMigrationTask;

public class MoveHarvesterSettingsToHigherNumber
extends DatabaseMigrationTask {
    protected AtomicInteger counter = new AtomicInteger(10000);

    protected String getHarvesterSettingsName() {
        return "Settings";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String selectHarvestersSQL = "SELECT * FROM Settings WHERE parentId = (SELECT id FROM Settings WHERE name='harvesting' and parentId=0)";
            ArrayList<HarvesterSetting> settings = new ArrayList<HarvesterSetting>();
            try (ResultSet resultSet = statement.executeQuery("SELECT * FROM Settings WHERE parentId = (SELECT id FROM Settings WHERE name='harvesting' and parentId=0)");){
                while (resultSet.next()) {
                    settings.add(new HarvesterSetting(resultSet.getInt("parentId"), resultSet));
                    this.counter.addAndGet(200);
                }
            }
            for (HarvesterSetting setting : settings) {
                setting.loadChildren(statement);
            }
            for (HarvesterSetting setting : settings) {
                setting.delete(statement);
            }
            for (HarvesterSetting setting : settings) {
                setting.write(statement);
            }
        }
    }

    private class HarvesterSetting {
        int originalId;
        int id;
        int parentId;
        String name;
        String value;
        List<HarvesterSetting> children = new ArrayList<HarvesterSetting>();

        public HarvesterSetting(int parentId, ResultSet resultSet) throws SQLException {
            this.id = MoveHarvesterSettingsToHigherNumber.this.counter.incrementAndGet();
            this.parentId = parentId;
            this.name = resultSet.getString("name");
            this.value = resultSet.getString("value");
            this.originalId = resultSet.getInt("id");
        }

        private void loadChildren(Statement statement) throws SQLException {
            try (ResultSet resultSet2 = statement.executeQuery("SELECT * FROM Settings where parentId = " + this.originalId);){
                while (resultSet2.next()) {
                    this.children.add(new HarvesterSetting(this.id, resultSet2));
                }
            }
            for (HarvesterSetting child : this.children) {
                child.loadChildren(statement);
            }
        }

        public void write(Statement statement) throws SQLException {
            String sql = String.format("INSERT INTO " + MoveHarvesterSettingsToHigherNumber.this.getHarvesterSettingsName() + " (id, parentId, name, value) VALUES (%s, %s, '%s', '%s')", this.id, this.parentId, this.name, this.value);
            statement.execute(sql);
            for (HarvesterSetting child : this.children) {
                child.write(statement);
            }
        }

        public void delete(Statement statement) throws SQLException {
            for (HarvesterSetting child : this.children) {
                child.delete(statement);
            }
            statement.execute("DELETE FROM Settings WHERE id=" + this.originalId);
        }
    }
}

