/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.feature.wrapper;

import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.feature.wrapper.XSDMapping;
import org.geotools.feature.NameImpl;

public abstract class FeatureWrapper {
    private ComplexAttribute underlyingComplexAttribute;

    public ComplexAttribute getUnderlyingComplexAttribute() {
        return this.underlyingComplexAttribute;
    }

    public void setUnderlyingComplexAttribute(ComplexAttribute underlyingComplexAttribute) {
        this.underlyingComplexAttribute = underlyingComplexAttribute;
    }

    public static <T extends FeatureWrapper> T wrap(ComplexAttribute complexAttribute, Class<T> clazz) throws InvalidClassException {
        try {
            FeatureWrapper wrapper;
            try {
                wrapper = (FeatureWrapper)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new InvalidClassException(String.format("Unable instantiate class of type '%s'.", clazz));
            }
            wrapper.setUnderlyingComplexAttribute(complexAttribute);
            String defaultNamespace = null;
            String defaultSeparator = null;
            XSDMapping classLevelXSDMapping = clazz.getAnnotation(XSDMapping.class);
            if (classLevelXSDMapping != null) {
                defaultNamespace = classLevelXSDMapping.namespace();
                defaultSeparator = classLevelXSDMapping.separator();
            }
            for (Field field : clazz.getFields()) {
                XSDMapping xsdMapping = field.getAnnotation(XSDMapping.class);
                if (xsdMapping == null) continue;
                Class<?> fieldType = field.getType();
                String path = xsdMapping.path();
                String namespace = xsdMapping.namespace().equals("") ? defaultNamespace : xsdMapping.namespace();
                String separator = xsdMapping.separator().equals("") ? defaultSeparator : xsdMapping.separator();
                NameImpl xsdName = new NameImpl(namespace, separator, xsdMapping.local());
                ComplexAttribute targetAttribute = complexAttribute;
                if (!path.equals("")) {
                    String[] steps;
                    for (String step : steps = path.split("/")) {
                        if (targetAttribute == null) {
                            throw new InvalidClassException(String.format("Unable to wrap attribute in class '%s'. Reference to %s could not be found in the attribute.", clazz, xsdMapping.local()));
                        }
                        targetAttribute = (ComplexAttribute)targetAttribute.getProperty(step);
                    }
                }
                if (FeatureWrapper.class.isAssignableFrom(fieldType)) {
                    ComplexAttribute featureWrapperAttribute = (ComplexAttribute)targetAttribute.getProperty((Name)xsdName);
                    if (featureWrapperAttribute == null) {
                        throw new InvalidClassException(String.format("Unable to wrap attribute in class '%s'. '%s' doesn't have required property '%s'.", clazz.getName(), targetAttribute.getName(), xsdName));
                    }
                    Name typeName = featureWrapperAttribute.getType().getName();
                    ComplexAttribute nestedComplexAttribute = (ComplexAttribute)featureWrapperAttribute.getProperty(typeName);
                    if (nestedComplexAttribute == null) {
                        throw new InvalidClassException(String.format("Unable to wrap attribute in class '%s'. '%s' doesn't have required property '%s'.", clazz.getName(), xsdName, typeName));
                    }
                    Object property = FeatureWrapper.wrap(nestedComplexAttribute, fieldType);
                    field.set(wrapper, property);
                    continue;
                }
                if (ArrayList.class.isAssignableFrom(fieldType)) {
                    Class collectionType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                    ArrayList<Object> collection = new ArrayList<Object>();
                    if (FeatureWrapper.class.isAssignableFrom(collectionType)) {
                        for (Property property : targetAttribute.getProperties((Name)xsdName)) {
                            Class fwClass = collectionType;
                            collection.add(FeatureWrapper.wrap((ComplexAttribute)property, fwClass));
                        }
                    } else {
                        for (Property property : targetAttribute.getProperties((Name)xsdName)) {
                            collection.add(property.getValue());
                        }
                    }
                    field.set(wrapper, collection);
                    continue;
                }
                Property property = targetAttribute.getProperty((Name)xsdName);
                if (property == null) {
                    throw new InvalidClassException(String.format("Unable to wrap attribute in class '%s'. %s could not be found in the attribute.", clazz, xsdName));
                }
                field.set(wrapper, property.getValue());
            }
            return (T)wrapper;
        }
        catch (IllegalAccessException iae) {
            throw new InvalidClassException(String.format("Unable to wrap attribute in class '%s'. Exception of type: '%s' was thrown with message: '%s'", clazz, iae.getClass(), iae.getMessage()));
        }
    }
}

