/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.other;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.riot.other.RDFDataException;
import org.apache.jena.riot.other.Transitive;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.graph.GNode;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.util.IteratorCollection;
import org.apache.jena.util.iterator.ExtendedIterator;

public class G {
    private static Node rdfType = NodeConst.nodeRDFType;

    private G() {
    }

    public static Node subject(Triple triple) {
        return triple == null ? null : triple.getSubject();
    }

    public static Node predicate(Triple triple) {
        return triple == null ? null : triple.getPredicate();
    }

    public static Node object(Triple triple) {
        return triple == null ? null : triple.getObject();
    }

    public static boolean isURI(Node n) {
        return n != null && n.isURI();
    }

    public static boolean isBlank(Node n) {
        return n != null && n.isBlank();
    }

    public static boolean isLiteral(Node n) {
        return n != null && n.isLiteral();
    }

    public static boolean isResource(Node n) {
        return n != null && (n.isURI() || n.isBlank());
    }

    public static boolean isNodeTriple(Node n) {
        return n != null && n.isNodeTriple();
    }

    public static boolean isNodeGraph(Node n) {
        return n != null && n.isNodeGraph();
    }

    public static boolean isNullOrAny(Node n) {
        return n == null || Node.ANY.equals((Object)n);
    }

    public static boolean hasDatatype(Node n, RDFDatatype datatype) {
        Objects.requireNonNull(n, "hasDatatype: first argument is null");
        Objects.requireNonNull(datatype, "hasDatatype: second argument is null");
        return G.isLiteral(n) && datatype.equals(n.getLiteralDatatype());
    }

    public static boolean isString(Node n) {
        return Util.isSimpleString((Node)n);
    }

    public static boolean isBoolean(Node n) {
        if (!n.isLiteral()) {
            throw new RDFDataException("Not a literal: " + NodeFmtLib.strTTL(n));
        }
        return G.hasDatatype(n, (RDFDatatype)XSDDatatype.XSDboolean);
    }

    public static Node nullAsAny(Node x) {
        return G.nullAsDft(x, Node.ANY);
    }

    public static Node nullAsDft(Node x, Node dft) {
        return x == null ? dft : x;
    }

    public static String asString(Node x) {
        if (!G.isString(x)) {
            throw new RDFDataException("Expected a string: found: " + NodeFmtLib.strTTL(x));
        }
        return x.getLiteralLexicalForm();
    }

    public static boolean contains(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return graph.contains(subject, predicate, object);
    }

    public static boolean containsNode(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        return GraphUtil.containsNode((Graph)graph, (Node)node);
    }

    public static boolean isOfType(Graph graph, Node node, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(type, "type");
        List<Node> allClasses = G.listSubClasses(graph, type);
        for (Node c : allClasses) {
            if (!G.hasType(graph, node, c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(Graph graph, Node node, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(type, "type");
        return G.contains(graph, node, NodeConst.nodeRDFType, type);
    }

    public static boolean hasProperty(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return graph.contains(subject, predicate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsOne(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        try (ExtendedIterator iter = graph.find(subject, predicate, object);){
            if (!iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            iter.next();
            boolean bl = !iter.hasNext();
            return bl;
        }
    }

    public static Node getSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.object(G.first(G.find(graph, subject, predicate, Node.ANY)));
    }

    public static Node getOneSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.object(G.findUniqueTriple(graph, subject, predicate, Node.ANY));
    }

    public static boolean hasOneSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.findZeroOneTriple(graph, subject, predicate, Node.ANY) != null;
    }

    public static Node getZeroOrOneSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.object(G.findZeroOneTriple(graph, subject, predicate, Node.ANY));
    }

    public static Node getPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.object(G.first(G.find(graph, Node.ANY, predicate, object)));
    }

    public static Node getOnePO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.subject(G.findUniqueTriple(graph, Node.ANY, predicate, object));
    }

    public static boolean hasOnePO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.findUniqueTriple(graph, Node.ANY, predicate, object) != null;
    }

    public static Node getZeroOrOnePO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.subject(G.findZeroOneTriple(graph, Node.ANY, predicate, object));
    }

    public static Triple getOne(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.findUniqueTriple(graph, subject, predicate, object);
    }

    public static Triple getZeroOrOne(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.findZeroOneTriple(graph, subject, predicate, object);
    }

    public static Triple getOneOrNull(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.findTripleOrNull(graph, subject, predicate, object);
    }

    public static Quad getOne(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(dsg, "DatasetGraph");
        return G.findUniqueQuad(dsg, graph, subject, predicate, object);
    }

    public static Quad getZeroOrOne(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(dsg, "DatasetGraph");
        return G.findZeroOneQuad(dsg, graph, subject, predicate, object);
    }

    public static Quad getOneOrNull(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(dsg, "DatasetGraph");
        return G.findQuadOrNull(dsg, graph, subject, predicate, object);
    }

    public static ExtendedIterator<Node> iterSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.find(graph, subject, predicate, null).mapWith(Triple::getObject);
    }

    public static List<Node> listSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.iterSP(graph, subject, predicate).toList();
    }

    public static long countSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return Iter.count(G.iterSP(graph, subject, predicate));
    }

    public static ExtendedIterator<Node> iterPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.find(graph, null, predicate, object).mapWith(Triple::getSubject);
    }

    public static List<Node> listPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.iterPO(graph, predicate, object).toList();
    }

    public static long countPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return Iter.count(G.iterPO(graph, predicate, object));
    }

    @Deprecated
    public static Iterator<Node> listSubjects(Graph graph) {
        return G.iterSubjects(graph);
    }

    @Deprecated
    public static Iterator<Node> listPredicates(Graph graph) {
        return G.iterPredicates(graph);
    }

    @Deprecated
    public static Iterator<Node> listObjects(Graph graph) {
        return G.iterObjects(graph);
    }

    public static Iterator<Node> iterSubjects(Graph graph) {
        Objects.requireNonNull(graph, "graph");
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter((Iterator)iter).map(Triple::getSubject).distinct();
    }

    public static Iterator<Node> iterPredicates(Graph graph) {
        Objects.requireNonNull(graph, "graph");
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter((Iterator)iter).map(Triple::getPredicate).distinct();
    }

    public static Iterator<Node> iterObjects(Graph graph) {
        Objects.requireNonNull(graph, "graph");
        ExtendedIterator iter = graph.find(Node.ANY, Node.ANY, Node.ANY);
        return Iter.iter((Iterator)iter).map(Triple::getObject).distinct();
    }

    public static Iterator<Node> iterSubjectsOfPredicate(Graph graph, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        ExtendedIterator iter = graph.find(Node.ANY, predicate, Node.ANY);
        return Iter.iter((Iterator)iter).map(Triple::getSubject).distinct();
    }

    public static Iterator<Node> iterObjectsOfPredicate(Graph graph, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        ExtendedIterator iter = graph.find(Node.ANY, predicate, Node.ANY);
        return Iter.iter((Iterator)iter).map(Triple::getObject).distinct();
    }

    public static List<Node> nodesOfTypeAsList(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        return G.find(graph, null, rdfType, type).mapWith(Triple::getSubject).toList();
    }

    public static List<Node> typesOfNodeAsList(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        return G.find(graph, node, rdfType, null).mapWith(Triple::getObject).toList();
    }

    public static Set<Node> nodesOfTypeAsSet(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        return G.find(graph, null, rdfType, type).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> typesOfNodeAsSet(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        return G.find(graph, node, rdfType, null).mapWith(Triple::getObject).toSet();
    }

    public static List<Node> rdfList(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        GNode gNode = GNode.create(graph, node);
        if (!GraphList.isListNode(gNode)) {
            return null;
        }
        return GraphList.members(gNode);
    }

    public static List<Node> getOneOrList(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        GNode gNode = GNode.create(graph, node);
        if (!GraphList.isListNode(gNode)) {
            return List.of(node);
        }
        return GraphList.members(gNode);
    }

    public static List<Node> listSubClasses(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        ArrayList<Node> acc = new ArrayList<Node>();
        Transitive.transitiveInc(graph, false, type, NodeConst.rdfsSubclassOf, acc);
        return acc;
    }

    public static List<Node> listSuperClasses(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        ArrayList<Node> acc = new ArrayList<Node>();
        Transitive.transitiveInc(graph, true, type, NodeConst.rdfsSubclassOf, acc);
        return acc;
    }

    public static Set<Node> subClasses(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        HashSet<Node> acc = new HashSet<Node>();
        Transitive.transitiveInc(graph, false, type, NodeConst.rdfsSubclassOf, acc);
        return acc;
    }

    public static Set<Node> superClasses(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        HashSet<Node> acc = new HashSet<Node>();
        Transitive.transitiveInc(graph, true, type, NodeConst.rdfsSubclassOf, acc);
        return acc;
    }

    public static List<Node> listTypesOfNodeRDFS(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        List<Node> types = G.typesOfNodeAsList(graph, node);
        ArrayList<Node> types2 = new ArrayList<Node>();
        types.forEach(t -> {
            List<Node> subClasses = G.listSuperClasses(graph, t);
            types2.addAll(subClasses);
        });
        return types2;
    }

    public static List<Node> listNodesOfTypeRDFS(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        List<Node> types = G.listSubClasses(graph, type);
        ArrayList<Node> nodes = new ArrayList<Node>();
        G.accNodesOfTypes(nodes, graph, types);
        return nodes;
    }

    public static Set<Node> allTypesOfNodeRDFS(Graph graph, Node node) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(node, "node");
        Set<Node> types = G.typesOfNodeAsSet(graph, node);
        HashSet<Node> types2 = new HashSet<Node>();
        types.forEach(t -> {
            List<Node> subClasses = G.listSuperClasses(graph, t);
            types2.addAll(subClasses);
        });
        return types2;
    }

    public static Set<Node> allNodesOfTypeRDFS(Graph graph, Node type) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(type, "type");
        Set<Node> types = G.subClasses(graph, type);
        HashSet<Node> nodes = new HashSet<Node>();
        G.accNodesOfTypes(nodes, graph, types);
        return nodes;
    }

    private static void accNodesOfTypes(Collection<Node> acc, Graph graph, Collection<Node> types) {
        types.forEach(t -> G.find(graph, null, rdfType, t).mapWith(Triple::getSubject).forEach(acc::add));
    }

    public static Set<Node> allSP(Graph graph, Node subject, Node predicate) {
        Objects.requireNonNull(graph, "graph");
        return G.find(graph, subject, predicate, null).mapWith(Triple::getObject).toSet();
    }

    public static Set<Node> allPO(Graph graph, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return G.find(graph, null, predicate, object).mapWith(Triple::getSubject).toSet();
    }

    public static long objectConnectiveness(Graph graph, Node object) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(object, "object");
        return Iter.count(G.find(graph, null, null, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean oneConnected(Graph graph, Node object) {
        Objects.requireNonNull(graph, "graph");
        Objects.requireNonNull(object, "object");
        try (ExtendedIterator<Triple> iter = G.find(graph, null, null, object);){
            if (!iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            iter.next();
            if (iter.hasNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public static long count(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return Iter.count((Iterator)graph.find(subject, predicate, object));
    }

    public static ExtendedIterator<Triple> find(Graph graph, Node subject, Node predicate, Node object) {
        Objects.requireNonNull(graph, "graph");
        return graph.find(subject, predicate, object);
    }

    public static ExtendedIterator<Triple> findAll(Graph graph) {
        Objects.requireNonNull(graph, "graph");
        return graph.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple findUniqueTriple(Graph graph, Node subject, Node predicate, Node object) {
        try (ExtendedIterator iter = graph.find(subject, predicate, object);){
            if (!iter.hasNext()) {
                throw new RDFDataException("No match : " + G.matchStr(subject, predicate, object));
            }
            Triple x = (Triple)iter.next();
            if (iter.hasNext()) {
                throw new RDFDataException("More than one match : " + G.matchStr(subject, predicate, object));
            }
            Triple triple = x;
            return triple;
        }
    }

    private static Quad findUniqueQuad(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Iterator<Quad> iter = dsg.find(graph, subject, predicate, object);
        if (!iter.hasNext()) {
            throw new RDFDataException("No match : " + G.matchStr(graph, subject, predicate, object));
        }
        Quad x = iter.next();
        if (iter.hasNext()) {
            throw new RDFDataException("More than one match : " + G.matchStr(graph, subject, predicate, object));
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple findTripleOrNull(Graph graph, Node subject, Node predicate, Node object) {
        try (ExtendedIterator iter = graph.find(subject, predicate, object);){
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple x = (Triple)iter.next();
            if (iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple triple = x;
            return triple;
        }
    }

    private static Quad findQuadOrNull(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Iterator<Quad> iter = dsg.find(graph, subject, predicate, object);
        if (!iter.hasNext()) {
            return null;
        }
        Quad x = iter.next();
        if (iter.hasNext()) {
            return null;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Triple findZeroOneTriple(Graph graph, Node subject, Node predicate, Node object) {
        try (ExtendedIterator iter = graph.find(subject, predicate, object);){
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple x = (Triple)iter.next();
            if (iter.hasNext()) {
                throw new RDFDataException("More than one match : " + G.matchStr(subject, predicate, object));
            }
            Triple triple = x;
            return triple;
        }
    }

    private static Quad findZeroOneQuad(DatasetGraph dsg, Node graph, Node subject, Node predicate, Node object) {
        Iterator<Quad> iter = dsg.find(graph, subject, predicate, object);
        if (!iter.hasNext()) {
            return null;
        }
        Quad x = iter.next();
        if (iter.hasNext()) {
            throw new RDFDataException("More than one match : " + G.matchStr(subject, predicate, object));
        }
        return x;
    }

    private static String matchStr(Node subject, Node predicate, Node object) {
        return "(" + NodeFmtLib.strNodesTTL(subject, predicate, object) + ")";
    }

    private static String matchStr(Node graph, Node subject, Node predicate, Node object) {
        return "(" + NodeFmtLib.strNodesTTL(graph, subject, predicate, object) + ")";
    }

    private static Triple first(ExtendedIterator<Triple> iter) {
        try {
            if (!iter.hasNext()) {
                Triple triple = null;
                return triple;
            }
            Triple triple = (Triple)iter.next();
            return triple;
        }
        finally {
            iter.close();
        }
    }

    @SafeVarargs
    public static <X> boolean allNonNull(X ... objects) {
        return G.countNonNulls(objects) == objects.length;
    }

    @SafeVarargs
    public static <X> boolean exactlyOneSet(X ... objects) {
        return G.countNonNulls(objects) == 1;
    }

    @SafeVarargs
    public static <X> X atMostOne(X ... objects) {
        int c = 0;
        X x = null;
        for (X obj : objects) {
            if (obj == null) continue;
            if (++c > 1) {
                throw new RDFDataException("atMostOne:" + Arrays.asList(objects));
            }
            if (x != null) continue;
            x = obj;
        }
        return x;
    }

    @SafeVarargs
    public static <X> int countNonNulls(X ... objects) {
        int x = 0;
        for (X obj : objects) {
            if (obj == null) continue;
            ++x;
        }
        return x;
    }

    public static Iter<Triple> quads2triples(Iterator<Quad> iter) {
        return Iter.iter(iter).map(Quad::asTriple);
    }

    public static Iterator<Node> quad2graphName(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getGraph);
    }

    public static Iterator<Node> quad2subject(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getSubject);
    }

    public static Iterator<Node> quad2predicate(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getPredicate);
    }

    public static Iterator<Node> quad2object(Iterator<Quad> iter) {
        return Iter.map(iter, Quad::getObject);
    }

    public static Iterator<Node> triple2subject(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getSubject);
    }

    public static Iterator<Node> triple2predicate(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getPredicate);
    }

    public static Iterator<Node> triple2object(Iterator<Triple> iter) {
        return Iter.map(iter, Triple::getObject);
    }

    public static void copyGraphSrcToDst(Graph src, Graph dst) {
        G.apply(src, arg_0 -> ((Graph)dst).add(arg_0));
    }

    public static void clear(Graph graph) {
        graph.clear();
    }

    public static void apply(Graph src, Consumer<Triple> action) {
        ExtendedIterator iter = src.find();
        G.apply((ExtendedIterator<Triple>)iter, action);
    }

    public static void apply(ExtendedIterator<Triple> iter, Consumer<Triple> action) {
        try {
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                action.accept(t);
            }
        }
        finally {
            iter.close();
        }
    }

    public static void deleteModify(Graph modify, Graph srcGraph) {
        GraphUtil.deleteFrom((Graph)modify, (Graph)srcGraph);
    }

    public static Iter<Quad> triples2quads(Node graphNode, Iterator<Triple> iter) {
        return Iter.iter(iter).map(t -> new Quad(graphNode, (Triple)t));
    }

    public static Iter<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return G.triples2quads(Quad.defaultGraphIRI, iter);
    }

    public static void execTxn(Graph graph, Runnable action) {
        TransactionHandler th = graph.getTransactionHandler();
        if (th.transactionsSupported()) {
            th.execute(action);
        } else {
            action.run();
        }
    }

    public static <X> X calcTxn(Graph graph, Supplier<X> action) {
        TransactionHandler th = graph.getTransactionHandler();
        if (th.transactionsSupported()) {
            return (X)th.calculate(action);
        }
        return action.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void findExec(Graph graph, Consumer<Triple> action, Node s, Node p, Node o) {
        try (ExtendedIterator<Triple> eIter = G.find(graph, s, p, o);){
            eIter.forEach(action);
        }
    }

    public static void addInto(Graph dstGraph, Graph srcGraph) {
        if (dstGraph == srcGraph && !dstGraph.getEventManager().listening()) {
            return;
        }
        dstGraph.getPrefixMapping().setNsPrefixes(srcGraph.getPrefixMapping());
        G.findExec(srcGraph, arg_0 -> ((Graph)dstGraph).add(arg_0), Node.ANY, Node.ANY, Node.ANY);
        dstGraph.getEventManager().notifyAddGraph(dstGraph, srcGraph);
    }

    private static void addIteratorWorker(Graph graph, Iterator<Triple> it) {
        List s = IteratorCollection.iteratorToList(it);
        G.addIteratorWorkerDirect(graph, s.iterator());
    }

    private static void addIteratorWorkerDirect(Graph graph, Iterator<Triple> it) {
        it.forEachRemaining(arg_0 -> ((Graph)graph).add(arg_0));
    }

    public static boolean containsBySameTerm(Graph graph, Triple triple) {
        return G.containsBySameTerm(graph, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsBySameTerm(Graph graph, Node s, Node p, Node o) {
        if (!graph.contains(s, p, o)) {
            return false;
        }
        ExtendedIterator iter = graph.find(s, p, o);
        Predicate<Triple> predicate = dataTriple -> G.sameTermMatch(s, p, o, dataTriple);
        iter = iter.filterKeep(predicate);
        try {
            boolean bl = iter.hasNext();
            return bl;
        }
        finally {
            iter.close();
        }
    }

    public static boolean sameTermMatch(Node matchSubj, Node matchPred, Node matchObj, Triple dataTriple) {
        return G.sameTermMatch(matchSubj, dataTriple.getSubject()) && G.sameTermMatch(matchPred, dataTriple.getPredicate()) && G.sameTermMatch(matchObj, dataTriple.getObject());
    }

    public static boolean sameTermMatch(Node match, Node data) {
        if (G.isNullOrAny(match)) {
            return true;
        }
        if (!match.isLiteral()) {
            return match.equals((Object)data);
        }
        if (!Util.isLangString((Node)data) || !Util.isLangString((Node)match)) {
            return match.equals((Object)data);
        }
        String lex1 = match.getLiteralLexicalForm();
        String lex2 = data.getLiteralLexicalForm();
        String lang1 = match.getLiteralLanguage();
        String lang2 = data.getLiteralLanguage();
        return lex1.equals(lex2) && lang1.equalsIgnoreCase(lang2);
    }
}

