/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.FloatCollection;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyFloatMap;
import bak.pcj.map.ShortKeyFloatMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractShortKeyFloatMap
implements ShortKeyFloatMap {
    protected AbstractShortKeyFloatMap() {
    }

    public void clear() {
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public float remove(short key) {
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            float value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultFloat();
    }

    public void putAll(ShortKeyFloatMap map) {
        ShortKeyFloatMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(short key) {
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public float get(short key) {
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultFloat();
    }

    public boolean containsValue(float value) {
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShortKeyFloatMap)) {
            return false;
        }
        ShortKeyFloatMap map = (ShortKeyFloatMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            short k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultShortHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultFloatHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public float tget(short key) {
        float value = this.get(key);
        if (value == MapDefaults.defaultFloat() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        ShortKeyFloatMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract FloatCollection values();

    public abstract float put(short var1, float var2);

    public abstract float lget();

    public abstract ShortSet keySet();

    public abstract ShortKeyFloatMapIterator entries();
}

