/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.mapfish.print.InvalidJsonValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.Transformer;
import org.mapfish.print.map.ParallelMapTileLoader;
import org.mapfish.print.map.readers.MapReader;
import org.mapfish.print.map.renderers.TileRenderer;
import org.mapfish.print.utils.PJsonObject;
import org.pvalsecc.misc.MatchAllSet;
import org.pvalsecc.misc.StringUtils;
import org.pvalsecc.misc.URIUtils;

public abstract class HTTPMapReader
extends MapReader {
    public static final Logger LOGGER = LogManager.getLogger(HTTPMapReader.class);
    protected final RenderingContext context;
    protected final PJsonObject params;
    protected final Map<String, List<String>> paramsToMerge = new HashMap<String, List<String>>();
    protected final Map<String, PJsonObject> mergeableParams;
    protected final URI baseUrl;
    public static final Set<String> OVERRIDE_ALL = new MatchAllSet<String>();

    protected HTTPMapReader(RenderingContext context, PJsonObject params) {
        super(params);
        this.context = context;
        this.params = params;
        try {
            this.mergeableParams = context.getMergeableParams(params.getString("baseURL"));
            this.buildParamsToMerge();
        }
        catch (Exception e) {
            throw new InvalidJsonValueException(params, "customParams", params.getJSONObject("customParams"), e);
        }
        try {
            this.baseUrl = new URI(params.getString("baseURL"));
        }
        catch (Exception e) {
            throw new InvalidJsonValueException(params, "baseURL", params.getString("baseURL"), e);
        }
        this.checkSecurity(params);
    }

    private void buildParamsToMerge() throws JSONException {
        PJsonObject customParams = this.params.optJSONObject("customParams");
        if (customParams != null) {
            ArrayList<String> toBeSkipped = new ArrayList<String>();
            Iterator<String> customParamsIt = customParams.keys();
            while (customParamsIt.hasNext()) {
                String key = customParamsIt.next();
                if (!this.mergeableParams.containsKey(key.toUpperCase())) continue;
                String value = this.getMergeableValue(customParams, toBeSkipped, key);
                this.paramsToMerge.put(key.toUpperCase(), new ArrayList<String>(Arrays.asList(value)));
            }
            for (String key : toBeSkipped) {
                customParams.getInternalObj().remove(key);
            }
        }
        for (String mergeable : this.mergeableParams.keySet()) {
            if (this.paramsToMerge.containsKey(mergeable)) continue;
            this.paramsToMerge.put(mergeable.toUpperCase(), new ArrayList<String>(Arrays.asList("")));
        }
    }

    protected String getMergeableValue(PJsonObject customParams, List<String> toBeSkipped, String key) throws JSONException {
        toBeSkipped.add(key);
        return customParams.getString(key);
    }

    @Override
    public boolean testMerge(MapReader other) {
        if (this.canMerge(other)) {
            HTTPMapReader http = (HTTPMapReader)other;
            for (String mergeable : this.mergeableParams.keySet()) {
                this.paramsToMerge.get(mergeable).addAll((Collection<String>)http.paramsToMerge.get(mergeable));
            }
            return true;
        }
        return false;
    }

    private void checkSecurity(PJsonObject params) {
        try {
            if (!this.context.getConfig().validateUri(this.baseUrl)) {
                throw new InvalidJsonValueException(params, "baseURL", this.baseUrl);
            }
        }
        catch (Exception e) {
            throw new InvalidJsonValueException(params, "baseURL", this.baseUrl, e);
        }
    }

    @Override
    public void render(Transformer transformer, ParallelMapTileLoader parallelMapTileLoader, String srs, boolean first) {
        try {
            URI commonUri = this.createCommonURI(transformer, srs, first);
            TileRenderer formatter = TileRenderer.get(this.getFormat());
            this.renderTiles(formatter, transformer, commonUri, parallelMapTileLoader);
        }
        catch (Exception e) {
            this.context.addError(e);
        }
    }

    protected URI createCommonURI(Transformer transformer, String srs, boolean first) throws URISyntaxException, UnsupportedEncodingException {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        PJsonObject customParams = this.params.optJSONObject("customParams");
        if (customParams != null) {
            Iterator<String> customParamsIt = customParams.keys();
            while (customParamsIt.hasNext()) {
                String key = customParamsIt.next();
                URIUtils.addParam(queryParams, key, customParams.getString(key));
            }
        }
        this.addMergeableQueryParams(queryParams);
        this.addCommonQueryParams(queryParams, transformer, srs, first);
        return URIUtils.addParams(this.baseUrl, queryParams, OVERRIDE_ALL);
    }

    private void addMergeableQueryParams(Map<String, List<String>> queryParams) {
        for (String key : this.mergeableParams.keySet()) {
            List<String> values = this.paramsToMerge.get(key);
            ArrayList<String> valuesWithDefaults = new ArrayList<String>();
            PJsonObject mergeableParam = this.mergeableParams.get(key);
            String separator = mergeableParam.optString("separator", ",");
            boolean includeParam = false;
            for (String value : values) {
                if (value == null || value.isEmpty()) {
                    value = mergeableParam.optString("defaultValue", "");
                } else {
                    includeParam = true;
                }
                valuesWithDefaults.add(value);
            }
            if (!includeParam) continue;
            URIUtils.addParam(queryParams, key, StringUtils.join(valuesWithDefaults, separator));
        }
    }

    protected abstract void renderTiles(TileRenderer var1, Transformer var2, URI var3, ParallelMapTileLoader var4) throws IOException, URISyntaxException;

    protected abstract TileRenderer.Format getFormat();

    protected abstract void addCommonQueryParams(Map<String, List<String>> var1, Transformer var2, String var3, boolean var4);

    @Override
    public boolean canMerge(MapReader other) {
        if (this.opacity != other.opacity) {
            return false;
        }
        if (other instanceof HTTPMapReader) {
            HTTPMapReader http = (HTTPMapReader)other;
            PJsonObject customParams = this.params.optJSONObject("customParams");
            PJsonObject customParamsOther = http.params.optJSONObject("customParams");
            return this.baseUrl.equals(http.baseUrl) && (customParams != null ? customParams.equals(customParamsOther) : customParamsOther == null);
        }
        return false;
    }
}

