/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Block;
import org.mapfish.print.config.layout.ExtraPage;
import org.mapfish.print.legend.LegendItemTable;
import org.mapfish.print.utils.PJsonArray;
import org.mapfish.print.utils.PJsonObject;

public class LegendsBlock
extends Block {
    public static final Logger LOGGER = LogManager.getLogger(LegendsBlock.class);
    private static String tempDir = System.getProperty("java.io.tmpdir");
    private static String fileSeparator = System.getProperty("file.separator");
    private boolean borders = false;
    private float maxWidth = Float.MAX_VALUE;
    private float maxHeight = Float.MAX_VALUE;
    private float iconMaxWidth = Float.MAX_VALUE;
    private float iconMaxHeight = 8.0f;
    private float[] iconPadding = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float textMaxWidth = Float.MAX_VALUE;
    private float[] textPadding = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float scale = 1.0f;
    private boolean inline = true;
    private float classIndentation = 20.0f;
    private float layerSpaceBefore = 5.0f;
    private float layerSpace = 5.0f;
    private float classSpace = 2.0f;
    private String layerFont = "Helvetica";
    protected float layerFontSize = 10.0f;
    private String classFont = "Helvetica";
    protected float classFontSize = 8.0f;
    private String fontEncoding = "Cp1252";
    private int horizontalAlignment = 1;
    private float[] columnPadding = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private int maxColumns = Integer.MAX_VALUE;
    private float fitWidth = 0.0f;
    private float fitHeight = 0.0f;
    private boolean failOnBrokenUrl = true;
    private boolean dontBreakItems = false;
    private boolean reorderColumns = false;
    private boolean overflow = false;
    private List<PdfPTable> extraColumns = new ArrayList<PdfPTable>();

    @Override
    public boolean hasExtraRendering() {
        return this.extraColumns.size() > 0;
    }

    @Override
    public void render(PJsonObject params, Block.PdfElement target, RenderingContext context) throws DocumentException {
        Renderer renderer = new Renderer(params, context);
        renderer.render(target);
    }

    public void setOverflow(boolean overflow) {
        this.overflow = overflow;
    }

    public void setFailOnBrokenUrl(boolean failOnBrokenUrl) {
        this.failOnBrokenUrl = failOnBrokenUrl;
    }

    public void setMaxColumns(int maxColumns) {
        if (maxColumns <= 0) {
            throw new InvalidValueException("maxColumns", maxColumns);
        }
        this.maxColumns = maxColumns;
    }

    public void setMaxWidth(double maxWidth) {
        this.maxWidth = this.getMaxValueIfZero((float)maxWidth, "maxWidth");
    }

    public void setMaxHeight(double maxHeight) {
        this.maxHeight = this.getMaxValueIfZero((float)maxHeight, "maxHeight");
    }

    public void setFitWidth(float fitWidth) {
        this.fitWidth = fitWidth;
    }

    public void setFitHeight(float fitHeight) {
        this.fitHeight = fitHeight;
    }

    public void setDefaultScale(double scale) {
        this.scale = (float)scale;
        if (scale < 0.0) {
            throw new InvalidValueException("scale", scale);
        }
        if (scale == 0.0) {
            this.scale = 1.0f;
        }
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    public void setIconMaxWidth(double maxIconWidth) {
        this.iconMaxWidth = (float)maxIconWidth;
        if (maxIconWidth < 0.0) {
            throw new InvalidValueException("maxIconWidth", maxIconWidth);
        }
        if (maxIconWidth == 0.0) {
            this.iconMaxWidth = Float.MAX_VALUE;
        }
    }

    public void setIconMaxHeight(double maxIconHeight) {
        this.iconMaxHeight = this.getMaxValueIfZero((float)maxIconHeight, "maxIconHeight");
    }

    public void setClassIndentation(double classIndentation) {
        this.classIndentation = (float)classIndentation;
        if (classIndentation < 0.0) {
            throw new InvalidValueException("classIndentation", classIndentation);
        }
    }

    public void setClassFont(String classFont) {
        this.classFont = classFont;
    }

    public void setClassFontSize(double classFontSize) {
        this.classFontSize = (float)classFontSize;
        if (classFontSize < 0.0) {
            throw new InvalidValueException("classFontSize", classFontSize);
        }
    }

    public String getClassFont() {
        return this.classFont;
    }

    protected Font getLayerPdfFont() {
        return FontFactory.getFont((String)this.layerFont, (String)this.fontEncoding, (float)this.layerFontSize);
    }

    protected Font getClassPdfFont() {
        return FontFactory.getFont((String)this.classFont, (String)this.fontEncoding, (float)this.classFontSize);
    }

    public void setLayerSpace(double layerSpace) {
        this.layerSpace = (float)layerSpace;
        if (layerSpace < 0.0) {
            throw new InvalidValueException("layerSpace", layerSpace);
        }
    }

    public void setClassSpace(double classSpace) {
        this.classSpace = (float)classSpace;
        if (classSpace < 0.0) {
            throw new InvalidValueException("classSpace", classSpace);
        }
    }

    public void setLayerFont(String layerFont) {
        this.layerFont = layerFont;
    }

    public void setLayerFontSize(double layerFontSize) {
        this.layerFontSize = (float)layerFontSize;
        if (layerFontSize < 0.0) {
            throw new InvalidValueException("layerFontSize", layerFontSize);
        }
    }

    public void setFontEncoding(String fontEncoding) {
        this.fontEncoding = fontEncoding;
    }

    public void setColumnMargin(String columnMargin) {
        this.columnPadding = this.getFloatCssValues(columnMargin);
    }

    public void setHorizontalAlignment(String value) {
        if (value.equalsIgnoreCase("left")) {
            this.horizontalAlignment = 0;
        } else if (value.equalsIgnoreCase("right")) {
            this.horizontalAlignment = 2;
        }
    }

    public void setIconPadding(String values) {
        this.iconPadding = this.getFloatCssValues(values);
    }

    public void setTextPadding(String values) {
        this.textPadding = this.getFloatCssValues(values);
    }

    private float[] getFloatCssValues(String values) {
        float[] result = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        String[] topRightBottomLeft = values.split(" ");
        int len = topRightBottomLeft.length > 4 ? 4 : topRightBottomLeft.length;
        switch (len) {
            default: {
                for (int i = 0; i < 4; ++i) {
                    result[i] = Float.parseFloat(topRightBottomLeft[0]);
                }
                break;
            }
            case 2: {
                result[0] = result[2] = Float.parseFloat(topRightBottomLeft[0]);
                result[1] = result[3] = Float.parseFloat(topRightBottomLeft[1]);
                break;
            }
            case 3: {
                result[0] = Float.parseFloat(topRightBottomLeft[0]);
                result[1] = result[3] = Float.parseFloat(topRightBottomLeft[1]);
                result[2] = Float.parseFloat(topRightBottomLeft[3]);
                break;
            }
            case 4: {
                for (int i = 0; i < len; ++i) {
                    float val;
                    result[i] = val = Float.parseFloat(topRightBottomLeft[i]);
                }
            }
        }
        return result;
    }

    public void setBorders(boolean value) {
        this.borders = value;
    }

    public void setTextMaxWidth(double textMaxWidth) {
        this.textMaxWidth = this.getMaxValueIfZero((float)textMaxWidth, "textMaxWidth");
    }

    public void setLayerSpaceBefore(double layerSpaceBefore) {
        if (layerSpaceBefore < 0.0) {
            throw new InvalidValueException("layerSpaceBefore", layerSpaceBefore);
        }
        this.layerSpaceBefore = (float)layerSpaceBefore;
    }

    public void setDontBreakItems(boolean dontBreakItems) {
        this.dontBreakItems = dontBreakItems;
    }

    public void setReorderColumns(boolean reorderColumns) {
        this.reorderColumns = reorderColumns;
    }

    private class Renderer {
        private String tempFilename;
        private Document tempDocument = new Document();
        private PdfWriter writer;
        private RenderingContext context;
        private ArrayList<PdfPTable> columns = new ArrayList();
        private final ArrayList<Float> columnsWidth = new ArrayList();
        private PdfPTable column;
        private int currentColumnIndex = 0;
        private float maxActualImageWidth = 0.0f;
        private float maxActualTextWidth = 0.0f;
        private final ArrayList<LegendItemTable> legendItems = new ArrayList();
        private float optimumIconCellWidth = 0.0f;
        private float optimumTextCellWidth = 0.0f;
        private PdfPCell leftCell;
        private PdfPCell rightCell;
        private float[] absoluteWidths;
        private boolean needTempDocument = true;
        private final HashMap<Integer, Float> subHeights = new HashMap();

        public Renderer(PJsonObject params, RenderingContext context) throws DocumentException {
            this.column = this.getDefaultOuterTable(1);
            this.columns.add(this.column);
            this.context = context;
            PJsonArray legends = context.getGlobalParams().optJSONArray("legends");
            if (legends == null || legends.size() == 0 || LegendsBlock.this.overflow && LegendsBlock.this.hasExtraRendering()) {
                this.needTempDocument = false;
            }
            if (this.needTempDocument) {
                this.makeTempDocument();
            }
        }

        public void render(Block.PdfElement target) throws DocumentException {
            int numColumns = 1;
            boolean overflowDone = false;
            if (LegendsBlock.this.overflow && LegendsBlock.this.hasExtraRendering()) {
                int extraColumnsUsed = LegendsBlock.this.extraColumns.size() > LegendsBlock.this.maxColumns ? LegendsBlock.this.maxColumns : LegendsBlock.this.extraColumns.size();
                this.columns.clear();
                for (int count = 0; count < extraColumnsUsed; ++count) {
                    this.columns.add(LegendsBlock.this.extraColumns.remove(0));
                }
                overflowDone = true;
            } else {
                this.absoluteWidths = new float[1];
                PJsonArray legends = this.context.getGlobalParams().optJSONArray("legends");
                float maxColumnWidth = LegendsBlock.this.maxWidth;
                if (legends != null && legends.size() > 0) {
                    for (int i = 0; i < legends.size(); ++i) {
                        try {
                            this.createLegend(legends.getJSONObject(i), i == 0);
                            continue;
                        }
                        catch (InvalidValueException e) {
                            if (LegendsBlock.this.failOnBrokenUrl) {
                                throw e;
                            }
                            LOGGER.warn("Error getting legend item " + legends.getJSONObject(i).getString("name"), (Throwable)e);
                        }
                    }
                    this.setOptimumCellWidths(maxColumnWidth);
                    this.setOptimumColumns(maxColumnWidth, LegendsBlock.this.reorderColumns);
                }
            }
            numColumns = this.columns.size();
            int finalTableColumns = numColumns > LegendsBlock.this.maxColumns ? LegendsBlock.this.maxColumns : numColumns;
            PdfPTable table = this.getDefaultOuterTable(finalTableColumns);
            if (LegendsBlock.this.maxWidth != Float.MAX_VALUE) {
                table.setTotalWidth(LegendsBlock.this.maxWidth);
            }
            if (LegendsBlock.this.overflow && this.columns.size() > finalTableColumns && !overflowDone) {
                for (int count = finalTableColumns; count < this.columns.size(); ++count) {
                    LegendsBlock.this.extraColumns.add(this.columns.get(count));
                }
                this.columns.removeAll(LegendsBlock.this.extraColumns);
                this.context.getExtraPages().add(ExtraPage.createAfter(this.context.getCurrentPosition(), LegendsBlock.this, this.context.getCurrentPage()));
            }
            for (PdfPTable col : this.columns) {
                PdfPCell cell = new PdfPCell(col);
                cell.setPaddingTop(LegendsBlock.this.columnPadding[0]);
                cell.setPaddingRight(LegendsBlock.this.columnPadding[1]);
                cell.setPaddingBottom(LegendsBlock.this.columnPadding[2]);
                cell.setPaddingLeft(LegendsBlock.this.columnPadding[3]);
                if (!LegendsBlock.this.borders) {
                    cell.setBorder(0);
                }
                table.addCell(cell);
            }
            if (!LegendsBlock.this.overflow && numColumns > LegendsBlock.this.maxColumns && numColumns % LegendsBlock.this.maxColumns != 0) {
                for (int count = 0; count < LegendsBlock.this.maxColumns - numColumns % LegendsBlock.this.maxColumns; ++count) {
                    PdfPCell cell = new PdfPCell(this.getDefaultOuterTable(1));
                    if (!LegendsBlock.this.borders) {
                        cell.setBorder(0);
                    }
                    table.addCell(cell);
                }
            }
            if (LegendsBlock.this.maxWidth < Float.MAX_VALUE) {
                table.setTotalWidth(LegendsBlock.this.maxWidth);
                table.setLockedWidth(true);
            }
            table.setHorizontalAlignment(LegendsBlock.this.horizontalAlignment);
            if (LegendsBlock.this.fitWidth != 0.0f || (double)LegendsBlock.this.fitHeight != 0.0) {
                this.tempDocument.add((Element)table);
                float aspectRatio = table.getTotalWidth() / table.getTotalHeight();
                if (LegendsBlock.this.fitWidth == 0.0f) {
                    LegendsBlock.this.fitWidth = aspectRatio * LegendsBlock.this.fitHeight;
                }
                if (LegendsBlock.this.fitHeight == 0.0f) {
                    LegendsBlock.this.fitHeight = LegendsBlock.this.fitWidth / aspectRatio;
                }
                PdfContentByte canvas = this.context.getDirectContent();
                PdfTemplate template = canvas.createTemplate(table.getTotalWidth(), table.getTotalHeight());
                table.writeSelectedRows(0, -1, 0.0f, table.getTotalHeight(), (PdfContentByte)template);
                Image img = Image.getInstance((PdfTemplate)template);
                img.scaleToFit(LegendsBlock.this.fitWidth, LegendsBlock.this.fitHeight);
                target.add((Element)new Chunk(img, 0.0f, 0.0f, true));
            } else {
                target.add((Element)table);
            }
            if (!overflowDone) {
                this.cleanup();
            }
        }

        private void setOptimumColumns(float maxColumnWidth, boolean reorderInColumns) throws DocumentException {
            int maxColumnsToUse = LegendsBlock.this.maxColumns;
            if (LegendsBlock.this.overflow) {
                maxColumnsToUse = Integer.MAX_VALUE;
            }
            if (this.legendItems.size() == 0 || maxColumnsToUse == 1) {
                reorderInColumns = false;
            }
            if (reorderInColumns) {
                this.reorderColumns(maxColumnWidth);
            } else {
                float totalHeight = 0.0f;
                int len = this.legendItems.size();
                for (int i = 0; i < len; ++i) {
                    LegendItemTable legendItem = this.legendItems.get(i);
                    this.computeOptimumLegendItemWidths(legendItem);
                    totalHeight += this.getHeight((Element)legendItem);
                    float cellPaddingTop = this.leftCell.getPaddingTop();
                    float spacingBefore = legendItem.getSpaceBefore();
                    if (totalHeight > LegendsBlock.this.maxHeight && i > 0) {
                        this.column = this.getDefaultOuterTable(1);
                        this.columns.add(this.column);
                        totalHeight = this.getHeight((Element)legendItem);
                        if (spacingBefore > 0.0f && cellPaddingTop > 0.0f) {
                            this.leftCell.setPaddingTop(cellPaddingTop - spacingBefore);
                            if (this.rightCell != null) {
                                this.rightCell.setPaddingTop(this.rightCell.getPaddingTop() - spacingBefore);
                            }
                        }
                        int columnsSize = this.columns.size();
                        if (LegendsBlock.this.maxColumns > 1) {
                            maxColumnWidth = LegendsBlock.this.maxWidth / (float)(columnsSize > maxColumnsToUse ? maxColumnsToUse : columnsSize) - LegendsBlock.this.columnPadding[1] - LegendsBlock.this.columnPadding[3];
                            if (maxColumnWidth < this.optimumIconCellWidth + this.optimumTextCellWidth) {
                                this.column = this.getDefaultOuterTable(1);
                                this.columns = new ArrayList(columnsSize);
                                this.columns.add(this.column);
                                i = -1;
                                this.setOptimumCellWidths(maxColumnWidth);
                                continue;
                            }
                            this.column.addCell((PdfPTable)legendItem);
                            continue;
                        }
                        this.column.addCell((PdfPTable)legendItem);
                        continue;
                    }
                    this.column.addCell((PdfPTable)legendItem);
                }
                this.column.setHorizontalAlignment(LegendsBlock.this.horizontalAlignment);
            }
        }

        private void reorderColumns(float maxColumnWidth) throws DocumentException {
            int maxColumnsToUse = LegendsBlock.this.maxColumns;
            if (LegendsBlock.this.overflow) {
                maxColumnsToUse = Integer.MAX_VALUE;
            }
            final HashMap<LegendItemTable, Float> itemHeights = new HashMap<LegendItemTable, Float>();
            int len = this.legendItems.size();
            for (int i = 0; i < len; ++i) {
                LegendItemTable legendItem = this.legendItems.get(i);
                this.computeOptimumLegendItemWidths(legendItem);
                float itemHeight = this.getHeight((Element)legendItem);
                itemHeights.put(legendItem, Float.valueOf(itemHeight));
            }
            TreeSet<LegendItemTable> orderedItems = new TreeSet<LegendItemTable>(new Comparator<LegendItemTable>(){

                @Override
                public int compare(LegendItemTable item1, LegendItemTable item2) {
                    int compareResult = ((Float)itemHeights.get((Object)item2)).compareTo((Float)itemHeights.get((Object)item1));
                    if (compareResult == 0) {
                        compareResult = 1;
                    }
                    return compareResult;
                }
            });
            orderedItems.addAll(this.legendItems);
            int maxFinalColumns = maxColumnsToUse > 0 ? Math.min(maxColumnsToUse, this.legendItems.size()) : this.legendItems.size();
            ArrayList candidateColumns = new ArrayList();
            for (int count = 0; count < maxFinalColumns; ++count) {
                candidateColumns.add(new ArrayList());
            }
            float[] occupiedSpace = new float[maxFinalColumns];
            for (int count = 0; count < maxFinalColumns; ++count) {
                occupiedSpace[count] = 0.0f;
            }
            ArrayList<LegendItemTable> notFitted = new ArrayList<LegendItemTable>();
            for (LegendItemTable itemTable : orderedItems) {
                boolean inserted = false;
                for (int count = 0; count < maxFinalColumns; ++count) {
                    float height = occupiedSpace[count];
                    Float itemHeight = (Float)itemHeights.get((Object)itemTable);
                    if (inserted || !(height + itemHeight.floatValue() <= LegendsBlock.this.maxHeight)) continue;
                    inserted = true;
                    int n = count;
                    occupiedSpace[n] = occupiedSpace[n] + itemHeight.floatValue();
                    ((List)candidateColumns.get(count)).add(itemTable);
                }
                if (inserted) continue;
                notFitted.add(itemTable);
            }
            for (int count = 0; count < maxFinalColumns; ++count) {
                if (!(occupiedSpace[count] > 0.0f)) continue;
                List items = (List)candidateColumns.get(count);
                if (count > 0) {
                    this.column = this.getDefaultOuterTable(1);
                }
                for (LegendItemTable item : items) {
                    this.column.addCell((PdfPTable)item);
                    this.column.setHorizontalAlignment(LegendsBlock.this.horizontalAlignment);
                }
                if (count <= 0) continue;
                this.columns.add(this.column);
            }
            for (LegendItemTable item : notFitted) {
                if (((Float)itemHeights.get((Object)item)).floatValue() > LegendsBlock.this.maxHeight) {
                    this.column = this.getDefaultOuterTable(1);
                }
                PdfPCell cell = new PdfPCell((PdfPTable)item);
                this.column.addCell((PdfPTable)item);
                this.column.setHorizontalAlignment(LegendsBlock.this.horizontalAlignment);
                if (!(((Float)itemHeights.get((Object)item)).floatValue() > LegendsBlock.this.maxHeight)) continue;
                this.columns.add(this.column);
            }
        }

        private int getColumnToUse(float itemHeight, float[] columnsHeight) {
            int columnIndex = -1;
            boolean allFill = false;
            int alternativeIndex = 0;
            if (columnsHeight[0] == 0.0f) {
                columnIndex = 0;
            } else {
                float smallerColumn = Float.MAX_VALUE;
                for (int i = 0; i < columnsHeight.length; ++i) {
                    float newHeight = columnsHeight[i] + itemHeight;
                    if (columnsHeight[i] == 0.0f) break;
                    if (columnsHeight[i] != 0.0f && newHeight < LegendsBlock.this.maxHeight && newHeight < smallerColumn) {
                        smallerColumn = newHeight;
                        columnIndex = i;
                    } else if (newHeight < smallerColumn) {
                        smallerColumn = newHeight;
                        alternativeIndex = i;
                    }
                    if (i != columnsHeight.length - 1 || columnIndex != -1) continue;
                    allFill = true;
                }
            }
            return allFill ? alternativeIndex : columnIndex;
        }

        private SetOptimumCellColumnsParameters computeNewParameters(LegendItemTable legendItem, SetOptimumCellColumnsParameters parameters) throws DocumentException {
            parameters.totalHeight = this.getHeight((Element)legendItem);
            ++parameters.columnsSize;
            if (parameters.spacingBefore > 0.0f && parameters.cellPaddingTop > 0.0f) {
                this.leftCell.setPaddingTop(parameters.cellPaddingTop - parameters.spacingBefore);
                if (this.rightCell != null) {
                    this.rightCell.setPaddingTop(this.rightCell.getPaddingTop() - parameters.spacingBefore);
                }
            }
            int columnsSize = parameters.columnsSize;
            parameters.maxColumnWidth = LegendsBlock.this.maxWidth / (float)(columnsSize > LegendsBlock.this.maxColumns ? LegendsBlock.this.maxColumns : columnsSize) - LegendsBlock.this.columnPadding[1] - LegendsBlock.this.columnPadding[3];
            if (parameters.maxColumnWidth < this.optimumIconCellWidth + this.optimumTextCellWidth) {
                parameters.index = -1;
                parameters.columnsSize = 1;
                this.setOptimumCellWidths(parameters.maxColumnWidth);
            }
            return parameters;
        }

        private float getTextWidth(String myString, Font pdfFont) {
            BaseFont baseFont = pdfFont.getBaseFont();
            float width = baseFont == null ? new Chunk(myString).getWidthPoint() : baseFont.getWidthPoint(myString, pdfFont.getSize());
            return width;
        }

        private Chunk createImageChunk(RenderingContext context, String iconItem, float maxIconWidth, float maxIconHeight, float scale) throws DocumentException {
            Chunk iconChunk = null;
            try {
                iconChunk = iconItem.indexOf("image%2Fsvg%2Bxml") != -1 ? PDFUtils.createImageChunkFromSVG(context, iconItem, maxIconWidth, maxIconHeight, scale) : PDFUtils.createImageChunk(context, maxIconWidth, maxIconHeight, scale, URI.create(iconItem), 0.0f);
            }
            catch (IOException e) {
                throw new DocumentException((Exception)e);
            }
            return iconChunk;
        }

        private void makeTempDocument() throws DocumentException {
            try {
                this.tempFilename = tempDir.indexOf(47) != -1 ? "" : "\\";
                long time = new Date().getTime();
                this.tempFilename = tempDir + fileSeparator + "mapfish-print-tmp-" + time + ".pdf";
                this.writer = PdfWriter.getInstance((Document)this.tempDocument, (OutputStream)new FileOutputStream(this.tempFilename));
                this.tempDocument.open();
            }
            catch (FileNotFoundException e) {
                throw new DocumentException((Exception)e);
            }
            catch (DocumentException e) {
                new File(this.tempFilename).delete();
                throw new DocumentException((Exception)((Object)e));
            }
        }

        private void cleanup() throws DocumentException {
            if (!this.needTempDocument) {
                return;
            }
            try {
                this.tempDocument.close();
                this.writer.close();
            }
            catch (Exception e) {
                throw new DocumentException(e);
            }
            finally {
                new File(this.tempFilename).delete();
            }
        }

        private float getHeight(Element element) throws DocumentException {
            this.tempDocument.add(element);
            if (element instanceof PdfPTable) {
                return ((PdfPTable)element).getTotalHeight();
            }
            if (element instanceof PdfPCell) {
                return ((PdfPCell)element).getHeight();
            }
            return -1.0f;
        }

        private void createLegend(PJsonObject layer, boolean isFirst) throws DocumentException {
            Font layerPdfFont = LegendsBlock.this.getLayerPdfFont();
            Font classPdfFont = LegendsBlock.this.getClassPdfFont();
            if (LegendsBlock.this.dontBreakItems) {
                float spaceBefore = isFirst ? 0.0f : LegendsBlock.this.layerSpaceBefore;
                PdfPCell[] cells = this.createTableCells(0.0f, layer, layerPdfFont, LegendsBlock.this.layerSpace, true, spaceBefore);
                LegendItemTable main = this.generateLegendItem(layer, spaceBefore, cells);
                main.completeRow();
                PJsonArray classes = layer.getJSONArray("classes");
                for (int j = 0; j < classes.size(); ++j) {
                    PJsonObject clazz = classes.getJSONObject(j);
                    cells = this.createTableCells(LegendsBlock.this.classIndentation, clazz, classPdfFont, LegendsBlock.this.classSpace, LegendsBlock.this.inline, 0.0f);
                    this.addCells(main, cells);
                }
                this.legendItems.add(main);
            } else {
                LegendItemTable legendItemTable = this.createTableLine(0.0f, layer, layerPdfFont, LegendsBlock.this.layerSpace, true, isFirst ? 0.0f : LegendsBlock.this.layerSpaceBefore);
                this.legendItems.add(legendItemTable);
                PJsonArray classes = layer.getJSONArray("classes");
                for (int j = 0; j < classes.size(); ++j) {
                    PJsonObject clazz = classes.getJSONObject(j);
                    legendItemTable = this.createTableLine(LegendsBlock.this.classIndentation, clazz, classPdfFont, LegendsBlock.this.classSpace, LegendsBlock.this.inline, 0.0f);
                    this.legendItems.add(legendItemTable);
                }
            }
        }

        private LegendItemTable generateLegendItem(PJsonObject layer, float spaceBefore, PdfPCell[] cells) throws DocumentException {
            String icon = layer.optString("icon");
            String color = layer.optString("color");
            PJsonArray iconsArray = layer.optJSONArray("icons");
            int iconsSize = iconsArray == null ? 0 : iconsArray.size();
            boolean haveNoIcon = icon == null && iconsSize == 0;
            boolean iconBeforeName = layer.optBool("iconBeforeName", true);
            return this.generateLegendItem(haveNoIcon, color, spaceBefore, iconBeforeName, cells);
        }

        private LegendItemTable generateLegendItem(boolean haveNoIcon, String color, float spaceBefore, boolean iconBeforeName, PdfPCell[] cells) throws DocumentException {
            LegendItemTable legendItemTable = haveNoIcon && color == null ? new LegendItemTable(1) : new LegendItemTable(2);
            legendItemTable.setIconBeforeName(iconBeforeName);
            legendItemTable.setTotalWidth(this.absoluteWidths);
            legendItemTable.getDefaultCell().setPadding(0.0f);
            legendItemTable.setSpaceBefore(spaceBefore);
            this.addCells(legendItemTable, cells);
            return legendItemTable;
        }

        private LegendItemTable createTableLine(float indent, PJsonObject node, Font pdfFont, float lineSpace, boolean defaultIconBeforeName, float spaceBefore) throws DocumentException {
            String icon = node.optString("icon");
            String color = node.optString("color");
            PJsonArray iconsArray = node.optJSONArray("icons");
            int iconsSize = iconsArray == null ? 0 : iconsArray.size();
            boolean haveNoIcon = icon == null && iconsSize == 0;
            boolean iconBeforeName = node.optBool("iconBeforeName", defaultIconBeforeName);
            PdfPCell[] cells = this.createTableCells(indent, node, pdfFont, lineSpace, defaultIconBeforeName, spaceBefore);
            LegendItemTable legendItemTable = this.generateLegendItem(haveNoIcon, color, spaceBefore, iconBeforeName, cells);
            return legendItemTable;
        }

        private void addCells(PdfPTable table, PdfPCell[] cells) {
            if (table != null && cells != null) {
                for (int i = 0; i < cells.length; ++i) {
                    table.addCell(cells[i]);
                }
            }
        }

        private PdfPCell[] createTableCells(float indent, PJsonObject node, Font pdfFont, float lineSpace, boolean defaultIconBeforeName, float spaceBefore) throws DocumentException {
            String name = node.getString("name");
            String icon = node.optString("icon");
            String color = node.optString("color");
            PJsonArray iconsArray = node.optJSONArray("icons");
            int iconsSize = iconsArray == null ? 0 : iconsArray.size();
            String[] icons = new String[iconsSize];
            boolean haveNoIcon = icon == null && iconsSize == 0;
            String iconScaleString = node.optString("scale", "" + LegendsBlock.this.scale);
            float iconScale = Float.parseFloat(iconScaleString);
            boolean iconBeforeName = node.optBool("iconBeforeName", defaultIconBeforeName);
            int i = -1;
            while (++i < iconsSize) {
                icons[i] = iconsArray.getString(i);
            }
            Phrase imagePhrase = new Phrase();
            float imageWidth = 0.0f;
            if (iconsSize > 0) {
                for (String myIcon : icons) {
                    Chunk iconChunk = this.createImageChunk(this.context, myIcon, LegendsBlock.this.iconMaxWidth, LegendsBlock.this.iconMaxHeight, iconScale);
                    imagePhrase.add((Element)iconChunk);
                    imageWidth += iconChunk.getImage().getPlainWidth() + LegendsBlock.this.iconPadding[1] + LegendsBlock.this.iconPadding[3];
                }
            } else if (icon != null) {
                Chunk iconChunk = this.createImageChunk(this.context, icon, LegendsBlock.this.iconMaxWidth, LegendsBlock.this.iconMaxHeight, iconScale);
                imagePhrase.add((Element)iconChunk);
                imageWidth = iconChunk.getImage().getPlainWidth() + LegendsBlock.this.iconPadding[1] + LegendsBlock.this.iconPadding[3];
            } else if (color != null) {
                int width = LegendsBlock.this.iconMaxWidth < Float.MAX_VALUE ? (int)LegendsBlock.this.iconMaxWidth : 10;
                int height = LegendsBlock.this.iconMaxHeight < Float.MAX_VALUE ? (int)LegendsBlock.this.iconMaxHeight : 10;
                BufferedImage buffered = new BufferedImage(width, height, 13);
                Graphics2D g2d = buffered.createGraphics();
                g2d.setColor(Color.decode(color));
                g2d.fillRect(0, 0, width, height);
                g2d.dispose();
                try {
                    Chunk iconChunk = new Chunk(Image.getInstance((java.awt.Image)buffered, null, (boolean)false), 0.0f, 0.0f, true);
                    imagePhrase.add((Element)iconChunk);
                    imageWidth = iconChunk.getImage().getPlainWidth() + LegendsBlock.this.iconPadding[1] + LegendsBlock.this.iconPadding[3];
                }
                catch (IOException e) {
                    throw new DocumentException((Exception)e);
                }
            } else {
                Chunk iconChunk = new Chunk("");
                imagePhrase.add((Element)iconChunk);
            }
            Phrase namePhrase = new Phrase();
            namePhrase.setFont(pdfFont);
            namePhrase.add(name);
            float textWidth = this.getTextWidth(name, pdfFont) + LegendsBlock.this.textPadding[1] + LegendsBlock.this.textPadding[3];
            int columnsWidthSize = this.columnsWidth.size();
            float maxWidthF = textWidth + imageWidth;
            if (columnsWidthSize <= this.currentColumnIndex) {
                this.columnsWidth.add(Float.valueOf(Math.min(LegendsBlock.this.maxWidth, maxWidthF)));
            } else if (columnsWidthSize >= 1 && this.currentColumnIndex == 0) {
                maxWidthF = Math.max(this.columnsWidth.get(0).floatValue(), maxWidthF);
                this.columnsWidth.set(0, Float.valueOf(Math.min(LegendsBlock.this.maxWidth, maxWidthF)));
            }
            this.absoluteWidths = null;
            if (haveNoIcon && color == null) {
                this.absoluteWidths = new float[1];
                this.absoluteWidths[0] = LegendsBlock.this.textMaxWidth + LegendsBlock.this.iconMaxWidth + LegendsBlock.this.iconPadding[1] + LegendsBlock.this.iconPadding[3] + LegendsBlock.this.textPadding[1] + LegendsBlock.this.textPadding[3];
            } else {
                this.absoluteWidths = new float[2];
                this.absoluteWidths[0] = LegendsBlock.this.iconMaxWidth + LegendsBlock.this.iconPadding[1] + LegendsBlock.this.iconPadding[3];
                this.absoluteWidths[1] = LegendsBlock.this.textMaxWidth + LegendsBlock.this.textPadding[1] + LegendsBlock.this.textPadding[3];
            }
            PdfPCell imageCell = null;
            if (!haveNoIcon) {
                imageCell = new PdfPCell(imagePhrase);
                float indentLeft = iconBeforeName ? indent : 0.0f;
                imageCell.setPaddingTop(spaceBefore + LegendsBlock.this.iconPadding[0]);
                imageCell.setPaddingRight(LegendsBlock.this.iconPadding[1]);
                imageCell.setPaddingBottom(lineSpace + LegendsBlock.this.iconPadding[2]);
                imageCell.setPaddingLeft(indentLeft + LegendsBlock.this.iconPadding[3]);
                if (!LegendsBlock.this.borders) {
                    imageCell.setBorder(0);
                }
            }
            if (color != null) {
                imageCell = new PdfPCell(imagePhrase);
            }
            PdfPCell nameCell = new PdfPCell(namePhrase);
            float indentLeft = haveNoIcon || !iconBeforeName ? indent : 0.0f;
            nameCell.setPaddingTop(spaceBefore + LegendsBlock.this.textPadding[0]);
            nameCell.setPaddingRight(LegendsBlock.this.textPadding[1]);
            nameCell.setPaddingBottom(lineSpace + LegendsBlock.this.textPadding[2]);
            nameCell.setPaddingLeft(indentLeft + LegendsBlock.this.textPadding[3]);
            if (!iconBeforeName && LegendsBlock.this.inline) {
                nameCell.setHorizontalAlignment(2);
            }
            if (!LegendsBlock.this.borders) {
                nameCell.setBorder(0);
            }
            if (!LegendsBlock.this.borders && color != null) {
                imageCell.setBorder(0);
            }
            this.maxActualImageWidth = Math.max(imageWidth, this.maxActualImageWidth);
            this.maxActualTextWidth = Math.max(textWidth, this.maxActualTextWidth);
            PdfPCell[] cells = new PdfPCell[nameCell != null && imageCell != null ? 2 : 1];
            if (LegendsBlock.this.inline) {
                if (iconBeforeName) {
                    if (imageCell != null) {
                        cells[0] = imageCell;
                    }
                    cells[cells.length - 1] = nameCell;
                } else {
                    cells[0] = nameCell;
                    if (imageCell != null) {
                        cells[1] = imageCell;
                    }
                }
            } else if (iconBeforeName) {
                if (imageCell != null) {
                    cells[0] = imageCell;
                }
                cells[cells.length - 1] = nameCell;
            } else {
                cells[0] = nameCell;
                if (imageCell != null) {
                    cells[1] = imageCell;
                }
            }
            return cells;
        }

        private PdfPTable getDefaultOuterTable(int numColumns) {
            PdfPTable pdfPTable = new PdfPTable(numColumns);
            if (!LegendsBlock.this.borders) {
                pdfPTable.getDefaultCell().setBorder(0);
            }
            pdfPTable.setWidthPercentage(100.0f);
            pdfPTable.getDefaultCell().setPadding(0.0f);
            pdfPTable.setSpacingAfter((float)LegendsBlock.this.spacingAfter);
            return pdfPTable;
        }

        private void computeOptimumLegendItemWidths(LegendItemTable legendItem) throws DocumentException {
            PdfPCell[] cells = LegendsBlock.this.dontBreakItems ? legendItem.getRow(1).getCells() : legendItem.getRow(0).getCells();
            int numCells = cells.length;
            this.leftCell = cells[0];
            this.rightCell = null;
            if (numCells > 1) {
                this.rightCell = cells[1];
            }
            if (numCells == 1) {
                this.absoluteWidths = new float[1];
                this.absoluteWidths[0] = this.optimumTextCellWidth + this.optimumIconCellWidth;
            } else {
                this.absoluteWidths = new float[2];
                if (legendItem.isIconBeforeName()) {
                    this.absoluteWidths[0] = this.optimumIconCellWidth;
                    this.absoluteWidths[1] = this.optimumTextCellWidth;
                } else {
                    this.absoluteWidths[0] = this.optimumTextCellWidth;
                    this.absoluteWidths[1] = this.optimumIconCellWidth;
                }
            }
            legendItem.setTotalWidth(this.absoluteWidths);
            legendItem.setLockedWidth(true);
            legendItem.setHorizontalAlignment(LegendsBlock.this.horizontalAlignment);
        }

        private void setOptimumCellWidths(float maxColumnWidth) {
            this.optimumIconCellWidth = Math.min(this.maxActualImageWidth + LegendsBlock.this.classIndentation, LegendsBlock.this.iconMaxWidth + LegendsBlock.this.classIndentation);
            this.optimumTextCellWidth = Math.min(this.maxActualTextWidth, LegendsBlock.this.textMaxWidth);
            this.optimumIconCellWidth = Math.min(this.optimumIconCellWidth, maxColumnWidth / 2.0f);
            this.optimumTextCellWidth = Math.min(this.optimumTextCellWidth, maxColumnWidth - this.optimumIconCellWidth);
        }

        private class SetOptimumCellColumnsParameters {
            float totalHeight;
            float spacingBefore;
            float cellPaddingTop;
            float maxColumnWidth;
            int index;
            int columnsSize;

            public SetOptimumCellColumnsParameters(float totalHeight, float spacingBefore, float cellPaddingTop, float maxColumnWidth, int index, int columnsSize) {
                this.totalHeight = totalHeight;
                this.spacingBefore = spacingBefore;
                this.cellPaddingTop = cellPaddingTop;
                this.maxColumnWidth = maxColumnWidth;
                this.index = index;
                this.columnsSize = columnsSize;
            }
        }
    }
}

