/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.classifier;

import it.geosolutions.jaiext.classifier.ColorMapTransform;
import it.geosolutions.jaiext.classifier.ColorMapTransformElement;
import it.geosolutions.jaiext.piecewise.GenericPiecewiseOpImage;
import it.geosolutions.jaiext.range.Range;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;

public class RasterClassifierOpImage<T extends ColorMapTransformElement>
extends GenericPiecewiseOpImage<T> {
    public static final String OPERATION_NAME = "RasterClassifier";

    public RasterClassifierOpImage(RenderedImage image, ColorMapTransform<T> lic, ImageLayout layout, Integer bandIndex, ROI roi, Range nodata, RenderingHints hints) {
        super(image, lic, RasterClassifierOpImage.prepareLayout(image, layout, lic), bandIndex, roi, nodata, RasterClassifierOpImage.prepareHints(hints), true);
        this.isByteData = false;
    }

    private static RenderingHints prepareHints(RenderingHints hints) {
        RenderingHints h = null;
        if (hints == null) {
            h = new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, false);
        } else {
            h = (RenderingHints)hints.clone();
            h.put(JAI.KEY_TRANSFORM_ON_COLORMAP, (Object)false);
        }
        return h;
    }

    private static <T extends ColorMapTransformElement> ImageLayout prepareLayout(RenderedImage image, ImageLayout layout, ColorMapTransform<T> lic) {
        IndexColorModel finalColorModel = lic.getColorModel();
        SampleModel finalSampleModel = lic.getSampleModel(image.getWidth(), image.getHeight());
        if (layout == null) {
            layout = new ImageLayout();
        }
        layout.setColorModel((ColorModel)finalColorModel);
        layout.setSampleModel(finalSampleModel);
        return layout;
    }
}

