/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.brewer.styling.builder.AbstractSLDBuilder;
import org.geotools.brewer.styling.builder.NamedLayerBuilder;
import org.geotools.brewer.styling.builder.UserLayerBuilder;

public class StyledLayerDescriptorBuilder
extends AbstractSLDBuilder<StyledLayerDescriptor> {
    List<AbstractSLDBuilder<? extends StyledLayer>> layers = new ArrayList<AbstractSLDBuilder<? extends StyledLayer>>();
    String name;
    String title;
    String sldAbstract;

    public StyledLayerDescriptorBuilder() {
        super(null);
        this.reset();
    }

    public StyledLayerDescriptorBuilder name(String name) {
        this.unset = false;
        this.name = name;
        return this;
    }

    public StyledLayerDescriptorBuilder title(String title) {
        this.unset = false;
        this.title = title;
        return this;
    }

    public StyledLayerDescriptorBuilder sldAbstract(String sldAbstract) {
        this.unset = false;
        this.sldAbstract = sldAbstract;
        return this;
    }

    public NamedLayerBuilder namedLayer() {
        this.unset = false;
        NamedLayerBuilder nlb = new NamedLayerBuilder(this);
        this.layers.add(nlb);
        return nlb;
    }

    public UserLayerBuilder userLayer() {
        this.unset = false;
        UserLayerBuilder ulb = new UserLayerBuilder(this);
        this.layers.add(ulb);
        return ulb;
    }

    public StyledLayerDescriptorBuilder reset() {
        this.unset = false;
        this.name = null;
        this.title = null;
        this.sldAbstract = null;
        this.layers.clear();
        return this;
    }

    public StyledLayerDescriptorBuilder reset(StyledLayerDescriptor other) {
        if (other == null) {
            return this.unset();
        }
        this.name = other.getName();
        this.title = other.getTitle();
        this.sldAbstract = other.getAbstract();
        this.layers.clear();
        for (StyledLayer layer : other.getStyledLayers()) {
            if (layer instanceof UserLayer) {
                this.layers.add(new UserLayerBuilder().reset((UserLayer)layer));
                continue;
            }
            if (!(layer instanceof NamedLayer)) continue;
            this.layers.add(new NamedLayerBuilder().reset((NamedLayer)layer));
        }
        this.unset = false;
        return this;
    }

    @Override
    public StyledLayerDescriptor build() {
        if (this.unset) {
            return null;
        }
        StyledLayerDescriptor sld = this.sf.createStyledLayerDescriptor();
        sld.setName(this.name);
        sld.setTitle(this.title);
        sld.setAbstract(this.sldAbstract);
        for (AbstractSLDBuilder<? extends StyledLayer> builder : this.layers) {
            sld.addStyledLayer((StyledLayer)builder.build());
        }
        this.reset();
        return sld;
    }

    @Override
    public StyledLayerDescriptor buildSLD() {
        return this.build();
    }

    @Override
    protected void buildSLDInternal(StyledLayerDescriptorBuilder sb) {
        sb.init(this);
    }

    @Override
    public StyledLayerDescriptorBuilder unset() {
        return (StyledLayerDescriptorBuilder)super.unset();
    }
}

