/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class EqlFeaturesKeys
implements JsonpSerializable {
    private final Number joinKeysTwo;
    private final Number joinKeysOne;
    private final Number joinKeysThree;
    private final Number joinKeysFiveOrMore;
    private final Number joinKeysFour;
    public static final JsonpDeserializer<EqlFeaturesKeys> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlFeaturesKeys::setupEqlFeaturesKeysDeserializer);

    private EqlFeaturesKeys(Builder builder) {
        this.joinKeysTwo = ApiTypeHelper.requireNonNull(builder.joinKeysTwo, this, "joinKeysTwo");
        this.joinKeysOne = ApiTypeHelper.requireNonNull(builder.joinKeysOne, this, "joinKeysOne");
        this.joinKeysThree = ApiTypeHelper.requireNonNull(builder.joinKeysThree, this, "joinKeysThree");
        this.joinKeysFiveOrMore = ApiTypeHelper.requireNonNull(builder.joinKeysFiveOrMore, this, "joinKeysFiveOrMore");
        this.joinKeysFour = ApiTypeHelper.requireNonNull(builder.joinKeysFour, this, "joinKeysFour");
    }

    public static EqlFeaturesKeys of(Function<Builder, ObjectBuilder<EqlFeaturesKeys>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Number joinKeysTwo() {
        return this.joinKeysTwo;
    }

    public final Number joinKeysOne() {
        return this.joinKeysOne;
    }

    public final Number joinKeysThree() {
        return this.joinKeysThree;
    }

    public final Number joinKeysFiveOrMore() {
        return this.joinKeysFiveOrMore;
    }

    public final Number joinKeysFour() {
        return this.joinKeysFour;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("join_keys_two");
        generator.write(this.joinKeysTwo.doubleValue());
        generator.writeKey("join_keys_one");
        generator.write(this.joinKeysOne.doubleValue());
        generator.writeKey("join_keys_three");
        generator.write(this.joinKeysThree.doubleValue());
        generator.writeKey("join_keys_five_or_more");
        generator.write(this.joinKeysFiveOrMore.doubleValue());
        generator.writeKey("join_keys_four");
        generator.write(this.joinKeysFour.doubleValue());
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupEqlFeaturesKeysDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::joinKeysTwo, JsonpDeserializer.numberDeserializer(), "join_keys_two");
        op.add(Builder::joinKeysOne, JsonpDeserializer.numberDeserializer(), "join_keys_one");
        op.add(Builder::joinKeysThree, JsonpDeserializer.numberDeserializer(), "join_keys_three");
        op.add(Builder::joinKeysFiveOrMore, JsonpDeserializer.numberDeserializer(), "join_keys_five_or_more");
        op.add(Builder::joinKeysFour, JsonpDeserializer.numberDeserializer(), "join_keys_four");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<EqlFeaturesKeys> {
        private Number joinKeysTwo;
        private Number joinKeysOne;
        private Number joinKeysThree;
        private Number joinKeysFiveOrMore;
        private Number joinKeysFour;

        public final Builder joinKeysTwo(Number value) {
            this.joinKeysTwo = value;
            return this;
        }

        public final Builder joinKeysOne(Number value) {
            this.joinKeysOne = value;
            return this;
        }

        public final Builder joinKeysThree(Number value) {
            this.joinKeysThree = value;
            return this;
        }

        public final Builder joinKeysFiveOrMore(Number value) {
            this.joinKeysFiveOrMore = value;
            return this;
        }

        public final Builder joinKeysFour(Number value) {
            this.joinKeysFour = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public EqlFeaturesKeys build() {
            this._checkSingleUse();
            return new EqlFeaturesKeys(this);
        }
    }
}

