/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain.auditable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EntityListeners;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.envers.Audited;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@MappedSuperclass
@EntityListeners(value={AuditingEntityListener.class})
@Audited
public abstract class AuditableEntity {
    @CreatedBy
    @Column(name="created_by")
    @JsonIgnore
    protected String createdBy;
    @LastModifiedBy
    @Column(name="last_modified_by", nullable=true, updatable=true)
    @JsonIgnore
    protected String lastModifiedBy;
    @LastModifiedDate
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_modified_date", nullable=true, updatable=true)
    @JsonIgnore
    protected Date lastModifiedDate;
    @CreatedDate
    @Column(name="created_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    @JsonIgnore
    private Date createdDate;

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }
}

