/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileShardResult;

public class SearchProfileResultsBuilder {
    private final Map<String, SearchProfileQueryPhaseResult> queryPhaseResults;

    public SearchProfileResultsBuilder(Map<String, SearchProfileQueryPhaseResult> queryPhaseResults) {
        this.queryPhaseResults = Collections.unmodifiableMap(queryPhaseResults);
    }

    public SearchProfileResults build(Collection<? extends SearchPhaseResult> fetchResults) {
        Map<String, SearchProfileShardResult> mergedShardResults = Maps.newMapWithExpectedSize(this.queryPhaseResults.size());
        for (SearchPhaseResult searchPhaseResult : fetchResults) {
            FetchSearchResult fr = searchPhaseResult.fetchResult();
            String key = fr.getSearchShardTarget().toString();
            SearchProfileQueryPhaseResult queryPhase = this.queryPhaseResults.get(key);
            if (queryPhase == null) {
                throw new IllegalStateException("Profile returned fetch phase information for [" + key + "] but didn't return query phase information. Query phase keys were " + this.queryPhaseResults.keySet());
            }
            mergedShardResults.put(key, new SearchProfileShardResult(queryPhase, fr.profileResult()));
        }
        for (Map.Entry entry : this.queryPhaseResults.entrySet()) {
            if (mergedShardResults.containsKey(entry.getKey())) continue;
            mergedShardResults.put((String)entry.getKey(), new SearchProfileShardResult((SearchProfileQueryPhaseResult)entry.getValue(), null));
        }
        return new SearchProfileResults(mergedShardResults);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SearchProfileResultsBuilder other = (SearchProfileResultsBuilder)obj;
        return this.queryPhaseResults.equals(other.queryPhaseResults);
    }

    public int hashCode() {
        return this.queryPhaseResults.hashCode();
    }
}

