/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.PrivateBinder;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.binder.AnnotatedBindingBuilder;
import org.elasticsearch.common.inject.internal.AbstractBindingBuilder;
import org.elasticsearch.common.inject.internal.BindingBuilder;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.SourceProvider;
import org.elasticsearch.common.inject.spi.Element;
import org.elasticsearch.common.inject.spi.Message;
import org.elasticsearch.common.inject.spi.ProviderLookup;

public final class Elements {
    public static List<Element> getElements(Module ... modules) {
        return Elements.getElements(Arrays.asList(modules));
    }

    public static List<Element> getElements(Iterable<? extends Module> modules) {
        RecordingBinder binder = new RecordingBinder();
        for (Module module : modules) {
            binder.install(module);
        }
        return Collections.unmodifiableList(binder.elements);
    }

    private static class RecordingBinder
    implements Binder,
    PrivateBinder {
        private final Set<Module> modules;
        private final List<Element> elements;
        private final Object source;
        private final SourceProvider sourceProvider;
        private final RecordingBinder parent;
        private static final Logger logger = LogManager.getLogger(Elements.class);

        private RecordingBinder() {
            this.modules = new HashSet<Module>();
            this.elements = new ArrayList<Element>();
            this.source = null;
            this.sourceProvider = new SourceProvider().plusSkippedClasses(Elements.class, RecordingBinder.class, AbstractModule.class, AbstractBindingBuilder.class, BindingBuilder.class);
            this.parent = null;
        }

        private RecordingBinder(RecordingBinder prototype, Object source, SourceProvider sourceProvider) {
            if (!(source == null ^ sourceProvider == null)) {
                throw new IllegalArgumentException();
            }
            this.modules = prototype.modules;
            this.elements = prototype.elements;
            this.source = source;
            this.sourceProvider = sourceProvider;
            this.parent = prototype.parent;
        }

        @Override
        public void install(Module module) {
            if (this.modules.add(module)) {
                RecordingBinder binder = this;
                try {
                    module.configure(binder);
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Collection<Message> messages = Errors.getMessagesFromThrowable(e);
                    if (!messages.isEmpty()) {
                        this.elements.addAll(messages);
                    }
                    this.addError(e);
                }
            }
        }

        @Override
        public void addError(String message, Object ... arguments) {
            this.elements.add(new Message(this.getSource(), Errors.format(message, arguments)));
        }

        private void addError(Throwable t) {
            String message = "An exception was caught and reported. Message: " + t.getMessage();
            this.elements.add(new Message(Collections.singletonList(this.getSource()), message, t));
        }

        @Override
        public void addError(Message message) {
            this.elements.add(message);
        }

        public <T> AnnotatedBindingBuilder<T> bind(Key<T> key) {
            return new BindingBuilder<T>(this, this.elements, this.getSource(), key);
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
            return this.bind((Key)Key.get(typeLiteral));
        }

        @Override
        public <T> AnnotatedBindingBuilder<T> bind(Class<T> type) {
            return this.bind((Key)Key.get(type));
        }

        @Override
        public <T> Provider<T> getProvider(Key<T> key) {
            ProviderLookup<T> element = new ProviderLookup<T>(this.getSource(), key);
            this.elements.add(element);
            return element.getProvider();
        }

        @Override
        public RecordingBinder withSource(Object source) {
            return new RecordingBinder(this, source, null);
        }

        @Override
        public RecordingBinder skipSources(Class<?> ... classesToSkip) {
            if (this.source != null) {
                return this;
            }
            SourceProvider newSourceProvider = this.sourceProvider.plusSkippedClasses(classesToSkip);
            return new RecordingBinder(this, null, newSourceProvider);
        }

        protected Object getSource() {
            Object ret = logger.isDebugEnabled() ? (this.sourceProvider != null ? this.sourceProvider.get() : this.source) : this.source;
            return ret == null ? "_unknown_" : ret;
        }

        public String toString() {
            return "Binder";
        }
    }
}

