/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.version;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public record CompatibilityVersions(TransportVersion transportVersion, Map<String, SystemIndexDescriptor.MappingsVersion> systemIndexMappingsVersion) implements Writeable,
ToXContentFragment
{
    public static CompatibilityVersions minimumVersions(Collection<CompatibilityVersions> compatibilityVersions) {
        TransportVersion minimumTransport = compatibilityVersions.stream().map(CompatibilityVersions::transportVersion).min(Comparator.naturalOrder()).orElse(TransportVersions.MINIMUM_COMPATIBLE);
        Map<String, SystemIndexDescriptor.MappingsVersion> minimumMappingsVersions = compatibilityVersions.stream().flatMap(mv -> mv.systemIndexMappingsVersion().entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> Stream.of(v1, v2).min(Comparator.naturalOrder()).get()));
        return new CompatibilityVersions(minimumTransport, minimumMappingsVersions);
    }

    public static void ensureVersionsCompatibility(CompatibilityVersions candidate, Collection<CompatibilityVersions> existing) {
        CompatibilityVersions minimumClusterVersions = CompatibilityVersions.minimumVersions(existing);
        if (candidate.transportVersion().before(minimumClusterVersions.transportVersion())) {
            throw new IllegalStateException("node with version [" + candidate.transportVersion().toReleaseVersion() + "] may not join a cluster with minimum version [" + minimumClusterVersions.transportVersion().toReleaseVersion() + "]");
        }
        HashMap<String, SystemIndexDescriptor.MappingsVersion> candidateInvalid = new HashMap<String, SystemIndexDescriptor.MappingsVersion>();
        HashMap<String, SystemIndexDescriptor.MappingsVersion> existingInvalid = new HashMap<String, SystemIndexDescriptor.MappingsVersion>();
        for (Map.Entry<String, SystemIndexDescriptor.MappingsVersion> candidates : candidate.systemIndexMappingsVersion().entrySet()) {
            SystemIndexDescriptor.MappingsVersion mapping = minimumClusterVersions.systemIndexMappingsVersion().get(candidates.getKey());
            if (!Objects.nonNull(mapping) || mapping.version() <= candidates.getValue().version()) continue;
            candidateInvalid.put(candidates.getKey(), candidates.getValue());
            existingInvalid.put(candidates.getKey(), minimumClusterVersions.systemIndexMappingsVersion().get(candidates.getKey()));
        }
        if (!candidateInvalid.isEmpty()) {
            throw new IllegalStateException("node with system index mappings versions [" + candidateInvalid + "] may not join a cluster with minimum system index mappings versions [" + existingInvalid + "]");
        }
    }

    public static CompatibilityVersions readVersion(StreamInput in) throws IOException {
        TransportVersion transportVersion = TransportVersion.readVersion(in);
        Map<String, SystemIndexDescriptor.MappingsVersion> mappingsVersions = Map.of();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
            mappingsVersions = in.readMap(SystemIndexDescriptor.MappingsVersion::new);
        }
        return new CompatibilityVersions(transportVersion, mappingsVersions);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportVersion.writeVersion(this.transportVersion(), out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
            out.writeMap(this.systemIndexMappingsVersion(), (o, v) -> v.writeTo(o));
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("transport_version", this.transportVersion().toString());
        builder.field("mappings_versions", this.systemIndexMappingsVersion);
        return builder;
    }
}

