/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public abstract class TransportLocalClusterStateAction<Request extends ActionRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final Executor executor;

    protected TransportLocalClusterStateAction(String actionName, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, Executor executor) {
        super(actionName, transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.clusterService = clusterService;
        this.executor = executor;
    }

    protected abstract ClusterBlockException checkBlock(Request var1, ClusterState var2);

    @Override
    protected final void doExecute(Task task, Request request, ActionListener<Response> listener) {
        ClusterState state = this.clusterService.state();
        ClusterBlockException clusterBlockException = this.checkBlock(request, state);
        if (clusterBlockException != null) {
            throw clusterBlockException;
        }
        this.executor.execute(ActionRunnable.wrap(listener, l -> this.localClusterStateOperation(task, request, state, (ActionListener<Response>)l)));
    }

    protected abstract void localClusterStateOperation(Task var1, Request var2, ClusterState var3, ActionListener<Response> var4) throws Exception;
}

