/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.tile.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.tile.Tile;
import org.geotools.tile.TileService;
import org.geotools.tile.util.TileLayer;

public class AsyncTileLayer
extends TileLayer {
    private CountDownLatch countDownLatch;

    public AsyncTileLayer(TileService service) {
        super(service);
    }

    @Override
    protected void renderTiles(Collection<Tile> tiles, Graphics2D g2d, ReferencedEnvelope viewportExtent, AffineTransform worldToImageTransform) {
        this.countDownLatch = new CountDownLatch(tiles.size());
        this.localRenderTiles(tiles, g2d, viewportExtent, worldToImageTransform);
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException ie) {
            Logger.getGlobal().log(Level.INFO, "", ie);
        }
        this.countDownLatch = null;
    }

    @Override
    protected void renderTile(Tile tile, Graphics2D g2d, double[] points) {
        Runnable r = () -> {
            BufferedImage img = this.getTileImage(tile);
            g2d.drawImage(img, (int)points[0], (int)points[1], (int)Math.ceil(points[2] - points[0]), (int)Math.ceil(points[3] - points[1]), null);
            this.countDownLatch.countDown();
        };
        new Thread(r).start();
    }

    protected void localRenderTiles(Collection<Tile> tiles, Graphics2D g2d, ReferencedEnvelope viewportExtent, AffineTransform worldToImageTransform) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        for (Tile tile : tiles) {
            ReferencedEnvelope tileEnvViewport;
            ReferencedEnvelope nativeTileEnvelope = tile.getExtent();
            try {
                tileEnvViewport = nativeTileEnvelope.transform(viewportExtent.getCoordinateReferenceSystem(), true);
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException(e);
            }
            double[] points = new double[4];
            points[0] = tileEnvViewport.getMinX();
            points[3] = tileEnvViewport.getMinY();
            points[2] = tileEnvViewport.getMaxX();
            points[1] = tileEnvViewport.getMaxY();
            worldToImageTransform.transform(points, 0, points, 0, 2);
            this.renderTile(tile, g2d, points);
        }
    }
}

