/*
 * Decompiled with CFR 0.152.
 */
package org.dlib.gui.treetable;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.dlib.gui.CustomLook;

class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private int visibleRow;
    private JTable jTable;

    public TreeTableCellRenderer(TreeNode treeNode) {
        super(treeNode);
    }

    public void updateUI() {
        super.updateUI();
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            defaultTreeCellRenderer.setBorderSelectionColor(null);
            defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, 0, n3, this.jTable.getHeight());
    }

    public void paint(Graphics graphics) {
        CustomLook.setup(graphics);
        graphics.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(graphics);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        this.visibleRow = n;
        return this;
    }

    public void setTable(JTable jTable) {
        this.jTable = jTable;
    }
}

