/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.MetadataProcessingReport;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.records.model.GroupOperations;
import org.fao.geonet.api.records.model.GroupPrivilege;
import org.fao.geonet.api.records.model.MetadataPublicationNotificationInfo;
import org.fao.geonet.api.records.model.SharingParameter;
import org.fao.geonet.api.records.model.SharingResponse;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.config.IPublicationConfig;
import org.fao.geonet.config.PublicationOption;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.domain.MetadataStatus;
import org.fao.geonet.domain.MetadataStatus_;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.utils.ObjectJSONUtils;
import org.fao.geonet.events.history.RecordGroupOwnerChangeEvent;
import org.fao.geonet.events.history.RecordOwnerChangeEvent;
import org.fao.geonet.events.history.RecordPrivilegesChangeEvent;
import org.fao.geonet.events.md.MetadataUnpublished;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataOperations;
import org.fao.geonet.kernel.datamanager.IMetadataStatus;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.FeedbackLanguages;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.OperationRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserGroupRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.repository.specification.OperationAllowedSpecs;
import org.fao.geonet.repository.specification.UserGroupSpecs;
import org.fao.geonet.util.MetadataPublicationMailNotifier;
import org.fao.geonet.util.UserUtil;
import org.fao.geonet.util.WorkflowUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@PreAuthorize(value="hasAuthority('Editor')")
@Controller(value="recordSharing")
@ReadWriteController
public class MetadataSharingApi
implements ApplicationEventPublisherAware {
    private static final String DEFAULT_PUBLICATION_TYPE_NAME = "default";
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    FeedbackLanguages feedbackLanguages;
    @Autowired
    DataManager dataManager;
    @Autowired
    IMetadataIndexer metadataIndexer;
    @Autowired
    AccessManager accessManager;
    @Autowired
    SettingManager sm;
    @Autowired
    IMetadataUtils metadataUtils;
    @Autowired
    IMetadataStatus metadataStatus;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    IMetadataValidator validator;
    @Autowired
    IMetadataManager metadataManager;
    @Autowired
    IMetadataOperations metadataOperations;
    @Autowired
    MetadataValidationRepository metadataValidationRepository;
    @Autowired
    OperationRepository operationRepository;
    @Autowired
    OperationAllowedRepository operationAllowedRepository;
    @Autowired
    GroupRepository groupRepository;
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserGroupRepository userGroupRepository;
    @Autowired
    MetadataStatusRepository metadataStatusRepository;
    @Autowired
    RoleHierarchy roleHierarchy;
    @Autowired
    MetadataPublicationMailNotifier metadataPublicationMailNotifier;
    @Autowired
    private IPublicationConfig publicationConfig;
    private ApplicationEventPublisher eventPublisher;

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public static Vector<OperationAllowedId> retrievePrivileges(ServiceContext context, String id, Integer userId, Integer groupId) {
        OperationAllowedRepository opAllowRepo = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
        int iMetadataId = Integer.parseInt(id);
        Specification spec = Specification.where((Specification)OperationAllowedSpecs.hasMetadataId((int)iMetadataId));
        if (groupId != null) {
            spec = spec.and(OperationAllowedSpecs.hasGroupId((int)groupId));
        }
        List operationsAllowed = opAllowRepo.findAllWithOwner(userId.intValue(), com.google.common.base.Optional.of((Object)spec));
        Vector<OperationAllowedId> result = new Vector<OperationAllowedId>();
        for (OperationAllowed operationAllowed : operationsAllowed) {
            result.add(operationAllowed.getId());
        }
        return result;
    }

    @Operation(summary="Get publication options.")
    @GetMapping(value={"/sharing/options"})
    @PreAuthorize(value="permitAll")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<PublicationOption> getPublicationOptions() {
        return this.publicationConfig.getPublicationOptions();
    }

    @Operation(summary="Set privileges for ALL group to publish the metadata for all users.")
    @RequestMapping(value={"/{metadataUuid}/publish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Settings updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void publish(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Publication type", required=false) @RequestParam(required=false) String publicationType, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        this.checkUserProfileToPublishMetadata(userSession);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)publicationType)) {
            publicationType = DEFAULT_PUBLICATION_TYPE_NAME;
        }
        this.shareMetadataWithReservedGroup(metadataUuid, true, publicationType, session, request);
        Optional<PublicationOption> publicationOption = this.publicationConfig.getPublicationOptionConfiguration(publicationType);
        if (publicationOption.isPresent()) {
            AbstractMetadata metadata = ApiUtils.getRecord(metadataUuid);
            this.publicationConfig.processMetadata(serviceContext, publicationOption.get(), metadata.getId(), true);
        }
    }

    @Operation(summary="Unsets privileges for ALL group to publish the metadata for all users.")
    @RequestMapping(value={"/{metadataUuid}/unpublish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Settings updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void unpublish(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Publication type", required=false) @RequestParam(required=false) String publicationType, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        UserSession userSession = ApiUtils.getUserSession(request.getSession());
        this.checkUserProfileToUnpublishMetadata(userSession);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)publicationType)) {
            publicationType = DEFAULT_PUBLICATION_TYPE_NAME;
        }
        this.shareMetadataWithReservedGroup(metadataUuid, false, publicationType, session, request);
        Optional<PublicationOption> publicationOption = this.publicationConfig.getPublicationOptionConfiguration(publicationType);
        if (publicationOption.isPresent()) {
            AbstractMetadata metadata = ApiUtils.getRecord(metadataUuid);
            this.publicationConfig.processMetadata(serviceContext, publicationOption.get(), metadata.getId(), false);
        }
    }

    @Operation(summary="Set record sharing", description="Privileges are assigned by group. User needs to be able to edit a record to set sharing settings. For reserved group (ie. Internet, Intranet & Guest), user MUST be reviewer of one group. For other group, if Only set privileges to user's groups is set in catalog configuration user MUST be a member of the group.<br/>Clear first allows to unset all operations first before setting the new ones.Clear option does not remove reserved groups operation if user is not an administrator, a reviewer or the owner of the record.<br/><a href='https://geonetwork-opensource.org/manuals/trunk/eng/users/user-guide/publishing/managing-privileges.html'>More info</a>")
    @RequestMapping(value={"/{metadataUuid}/sharing"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Settings updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void share(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Privileges", required=true) @RequestBody(required=true) SharingParameter sharing, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale[] feedbackLocales = this.feedbackLanguages.getLocales(request.getLocale());
        boolean skipAllReservedGroup = !this.accessManager.hasReviewPermission(context, Integer.toString(metadata.getId()));
        List operationList = this.operationRepository.findAll();
        HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
        for (org.fao.geonet.domain.Operation o : operationList) {
            operationMap.put(o.getName(), o.getId());
        }
        List<GroupOperations> privileges = sharing.getPrivileges();
        ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
        boolean notifyByEmail = org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.sm.getValue("system/metadataprivs/publication/notificationLevel")});
        this.setOperations(sharing, this.dataManager, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, null, request, metadataListToNotifyPublication, notifyByEmail);
        this.metadataIndexer.indexMetadataPrivileges(metadata.getUuid(), metadata.getId());
        if (notifyByEmail && !metadataListToNotifyPublication.isEmpty()) {
            this.metadataPublicationMailNotifier.notifyPublication(feedbackLocales, metadataListToNotifyPublication);
        }
    }

    @Operation(summary="Publish one or more records", description="See record sharing for more details.")
    @RequestMapping(value={"/publish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about updated privileges."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport publishMultipleRecords(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Publication type", required=false) @RequestParam(required=false) String publicationType, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        String publicationTypeToUse = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)publicationType) ? publicationType : DEFAULT_PUBLICATION_TYPE_NAME;
        SharingParameter sharing = this.buildSharingForPublicationConfig(true, publicationTypeToUse);
        MetadataProcessingReport metadataProcessingReport = this.shareSelection(uuids, bucket, sharing, session, request);
        Optional<PublicationOption> publicationOption = this.publicationConfig.getPublicationOptionConfiguration(publicationTypeToUse);
        if (publicationOption.isPresent()) {
            Set<Integer> metadataProcessed = metadataProcessingReport.getMetadata();
            for (Integer metadataId : metadataProcessed) {
                this.publicationConfig.processMetadata(serviceContext, publicationOption.get(), metadataId, true);
            }
        }
        return metadataProcessingReport;
    }

    @Operation(summary="Un-publish one or more records", description="See record sharing for more details.")
    @RequestMapping(value={"/unpublish"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about updated privileges."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport unpublishMultipleRecords(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Publication type", required=false) @RequestParam(required=false) String publicationType, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        String publicationTypeToUse = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)publicationType) ? publicationType : DEFAULT_PUBLICATION_TYPE_NAME;
        SharingParameter sharing = this.buildSharingForPublicationConfig(false, publicationTypeToUse);
        MetadataProcessingReport metadataProcessingReport = this.shareSelection(uuids, bucket, sharing, session, request);
        Optional<PublicationOption> publicationOption = this.publicationConfig.getPublicationOptionConfiguration(publicationTypeToUse);
        if (publicationOption.isPresent()) {
            Set<Integer> metadataProcessed = metadataProcessingReport.getMetadata();
            for (Integer metadataId : metadataProcessed) {
                this.publicationConfig.processMetadata(serviceContext, publicationOption.get(), metadataId, false);
            }
        }
        return metadataProcessingReport;
    }

    @Operation(summary="Set sharing settings for one or more records", description="See record sharing for more details.")
    @RequestMapping(value={"/sharing"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Report about updated privileges."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Editors can access it.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public MetadataProcessingReport shareMultipleRecords(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="Privileges", required=true) @RequestBody(required=true) SharingParameter sharing, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        return this.shareSelection(uuids, bucket, sharing, session, request);
    }

    private void setOperations(SharingParameter sharing, DataManager dataMan, ServiceContext context, ApplicationContext appContext, AbstractMetadata metadata, Map<String, Integer> operationMap, List<GroupOperations> privileges, Integer userId, boolean skipAllReservedGroup, MetadataProcessingReport report, HttpServletRequest request, List<MetadataPublicationNotificationInfo> metadataListToNotifyPublication, boolean notifyByMail) throws Exception {
        if (privileges != null) {
            Object mdStatus;
            Optional groupOwner;
            boolean isGroupWithEnabledWorkflow;
            ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
            boolean sharingChanges = false;
            boolean allowPublishInvalidMd = this.sm.getValueAsBool("metadata/workflow/allowPublishInvalidMd");
            boolean allowPublishNonApprovedMd = this.sm.getValueAsBool("metadata/workflow/allowPublishNonApprovedMd");
            boolean isMdWorkflowEnable = this.sm.getValueAsBool("metadata/workflow/enable");
            Integer groupOwnerId = metadata.getSourceInfo().getGroupOwner();
            if (isMdWorkflowEnable && groupOwnerId != null && (isGroupWithEnabledWorkflow = WorkflowUtil.isGroupWithEnabledWorkflow((String)((Group)(groupOwner = this.groupRepository.findById((Object)groupOwnerId)).get()).getName())) && (mdStatus = this.metadataStatus.getStatus(metadata.getId())) != null && mdStatus.getStatusValue().getId() == Integer.parseInt("3")) {
                List allGroupOps = privileges.stream().filter(p -> p.getGroup().intValue() == ReservedGroup.all.getId()).collect(Collectors.toList());
                for (GroupOperations groupOperations : allGroupOps) {
                    if (!groupOperations.getOperations().containsValue(true)) continue;
                    throw new IllegalStateException(String.format("Retired metadata %s can't be published.", metadata.getUuid()));
                }
            }
            SharingResponse sharingBefore = this.getRecordSharingSettings(metadata.getUuid(), request.getSession(), request);
            this.checkChangesAllowedToUserProfileForReservedGroups(context.getUserSession(), sharingBefore, privileges, !sharing.isClear());
            ArrayList<Integer> excludeFromDelete = new ArrayList<Integer>();
            for (Group group : this.groupRepository.findByMinimumProfileForPrivilegesNotNull()) {
                if (this.canUserChangePrivilegesForGroup(context, group)) continue;
                excludeFromDelete.add(group.getId());
            }
            if (skipAllReservedGroup) {
                excludeFromDelete.add(ReservedGroup.all.getId());
                excludeFromDelete.add(ReservedGroup.intranet.getId());
                excludeFromDelete.add(ReservedGroup.guest.getId());
            }
            if (sharing.isClear()) {
                this.metadataOperations.deleteMetadataOper(String.valueOf(metadata.getId()), excludeFromDelete);
            }
            block4: for (GroupOperations p3 : privileges) {
                for (Map.Entry entry : p3.getOperations().entrySet()) {
                    Integer opId = operationMap.get(entry.getKey());
                    if (opId.intValue() == ReservedOperation.editing.getId() && ReservedGroup.isReserved((int)p3.getGroup())) continue;
                    if (Boolean.TRUE.equals(entry.getValue())) {
                        if (p3.getGroup().intValue() == ReservedGroup.all.getId()) {
                            try {
                                this.checkCanPublishToAllGroup(context, messages, metadata, allowPublishInvalidMd, allowPublishNonApprovedMd);
                            }
                            catch (Exception ex) {
                                if (report != null) {
                                    report.addMetadataError(metadata, ex.getMessage());
                                    continue block4;
                                }
                                throw ex;
                            }
                        }
                        dataMan.setOperation(context, metadata.getId(), p3.getGroup().intValue(), opId.intValue());
                        sharingChanges = true;
                        continue;
                    }
                    if (sharing.isClear() || !Boolean.TRUE.equals((Boolean)entry.getValue() == false)) continue;
                    dataMan.unsetOperation(context, metadata.getId(), p3.getGroup().intValue(), opId.intValue());
                    sharingChanges = true;
                }
            }
            Optional<GroupPrivilege> allGroupPrivsBefore = sharingBefore.getPrivileges().stream().filter(p -> p.getGroup().intValue() == ReservedGroup.all.getId()).findFirst();
            boolean publishedBefore = allGroupPrivsBefore.get().getOperations().get(ReservedOperation.view.name());
            if (sharing.isClear() && publishedBefore && !this.metadataUtils.isMetadataPublished(metadata.getId())) {
                this.eventPublisher.publishEvent((ApplicationEvent)new MetadataUnpublished(metadata));
            }
            if (notifyByMail) {
                boolean bl;
                Optional<GroupOperations> allGroupOpsAfter = privileges.stream().filter(p -> p.getGroup().intValue() == ReservedGroup.all.getId()).findFirst();
                boolean bl2 = bl = allGroupOpsAfter.isPresent() ? allGroupOpsAfter.get().getOperations().getOrDefault(ReservedOperation.view.name(), publishedBefore) : publishedBefore;
                if (publishedBefore != bl) {
                    MetadataPublicationNotificationInfo metadataNotificationInfo = new MetadataPublicationNotificationInfo();
                    metadataNotificationInfo.setMetadataUuid(metadata.getUuid());
                    metadataNotificationInfo.setMetadataId(metadata.getId());
                    metadataNotificationInfo.setGroupId(metadata.getSourceInfo().getGroupOwner());
                    metadataNotificationInfo.setPublished(bl);
                    metadataNotificationInfo.setPublicationDateStamp(new ISODate());
                    Optional publishUser = this.userRepository.findById((Object)userId);
                    if (publishUser.isPresent()) {
                        metadataNotificationInfo.setPublisherUser(((User)publishUser.get()).getUsername());
                    }
                    if (isMdWorkflowEnable) {
                        Optional<MetadataStatus> submittedStatus;
                        String sortField = SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataStatus_.changeDate});
                        List statusList = this.metadataStatusRepository.findAllByMetadataIdAndByType(metadata.getId(), StatusValueType.workflow, Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{sortField}));
                        Optional<MetadataStatus> approvedStatus = statusList.stream().filter(status -> status.getStatusValue().getId() == Integer.parseInt("2")).findFirst();
                        if (approvedStatus.isPresent()) {
                            Optional reviewerUser = this.userRepository.findById((Object)approvedStatus.get().getUserId());
                            reviewerUser.ifPresent(user -> metadataNotificationInfo.setReviewerUser(user.getUsername()));
                        }
                        if ((submittedStatus = statusList.stream().filter(status -> status.getStatusValue().getId() == Integer.parseInt("4")).findFirst()).isPresent()) {
                            Optional submitterUser = this.userRepository.findById((Object)submittedStatus.get().getUserId());
                            submitterUser.ifPresent(user -> metadataNotificationInfo.setSubmitterUser(user.getUsername()));
                        }
                    }
                    metadataListToNotifyPublication.add(metadataNotificationInfo);
                }
            }
            if (sharingChanges) {
                new RecordPrivilegesChangeEvent(Integer.valueOf(metadata.getId()), userId, ObjectJSONUtils.convertObjectInJsonObject(sharingBefore.getPrivileges(), (String)"sharing"), ObjectJSONUtils.convertObjectInJsonObject(privileges, (String)"sharing")).publish(appContext);
            }
        }
    }

    @Operation(summary="Get record sharing settings", description="Return current sharing options for a record.")
    @RequestMapping(value={"/{metadataUuid}/sharing"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="The record sharing settings."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to view the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public SharingResponse getRecordSharingSettings(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, request);
        ServiceContext context = ApiUtils.createServiceContext(request);
        UserSession userSession = ApiUtils.getUserSession(session);
        SharingResponse sharingResponse = new SharingResponse();
        sharingResponse.setOwner(userSession.getUserId());
        Integer groupOwner = metadata.getSourceInfo().getGroupOwner();
        if (groupOwner != null) {
            sharingResponse.setGroupOwner(String.valueOf(groupOwner));
        }
        String network = this.sm.getValue("system/intranet/network");
        boolean hasNetworkConfig = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)network);
        Set userGroups = this.accessManager.getUserGroups(userSession, context.getIpAddress(), false);
        List elGroup = this.groupRepository.findAll();
        List allOperations = this.operationRepository.findAll();
        ArrayList<GroupPrivilege> groupPrivileges = new ArrayList<GroupPrivilege>(elGroup.size());
        if (elGroup != null) {
            for (Group g : elGroup) {
                if (!hasNetworkConfig && g.getId() == ReservedGroup.intranet.getId()) continue;
                GroupPrivilege groupPrivilege = new GroupPrivilege();
                groupPrivilege.setGroup(g.getId());
                groupPrivilege.setReserved(g.isReserved());
                groupPrivilege.setUserGroup(userGroups.contains(g.getId()));
                Specification hasGroupId = UserGroupSpecs.hasGroupId((Integer)g.getId());
                Specification hasUserId = UserGroupSpecs.hasUserId((int)userSession.getUserIdAsInt());
                Specification hasUserIdAndGroupId = Specification.where((Specification)hasGroupId).and(hasUserId);
                List userGroupEntities = this.userGroupRepository.findAll(hasUserIdAndGroupId);
                ArrayList<Profile> userGroupProfile = new ArrayList<Profile>();
                for (UserGroup ug : userGroupEntities) {
                    userGroupProfile.add(ug.getProfile());
                }
                groupPrivilege.setUserProfile(userGroupProfile);
                groupPrivilege.setRestricted(!this.canUserChangePrivilegesForGroup(context, g));
                Specification hasGroupIdAndMetadataId = Specification.where((Specification)OperationAllowedSpecs.hasGroupId((int)g.getId())).and(OperationAllowedSpecs.hasMetadataId((int)metadata.getId()));
                List operationAllowedForGroup = this.operationAllowedRepository.findAll(hasGroupIdAndMetadataId);
                HashMap<String, Boolean> operations = new HashMap<String, Boolean>(allOperations.size());
                for (org.fao.geonet.domain.Operation o : allOperations) {
                    boolean operationSetForGroup = false;
                    for (OperationAllowed operationAllowed : operationAllowedForGroup) {
                        if (o.getId() != operationAllowed.getId().getOperationId()) continue;
                        operationSetForGroup = true;
                        break;
                    }
                    operations.put(o.getName(), operationSetForGroup);
                }
                groupPrivilege.setOperations(operations);
                groupPrivileges.add(groupPrivilege);
            }
        }
        sharingResponse.setPrivileges(groupPrivileges);
        return sharingResponse;
    }

    @Operation(summary="Set record group", description="A record is related to one group.")
    @RequestMapping(value={"/{metadataUuid}/group"}, method={RequestMethod.PUT})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Record group updated.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void setRecordGroup(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Group identifier", required=true) @RequestBody(required=true) Integer groupIdentifier, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        Optional group = this.groupRepository.findById((Object)groupIdentifier);
        if (!group.isPresent()) {
            throw new ResourceNotFoundException(String.format("Group with identifier '%s' not found.", groupIdentifier));
        }
        Integer previousGroup = metadata.getSourceInfo().getGroupOwner();
        Group oldGroup = null;
        if (previousGroup != null) {
            oldGroup = (Group)this.groupRepository.findById((Object)previousGroup).get();
        }
        metadata.getSourceInfo().setGroupOwner(groupIdentifier);
        this.metadataManager.save(metadata);
        this.dataManager.indexMetadata(String.valueOf(metadata.getId()), true);
        new RecordGroupOwnerChangeEvent(Integer.valueOf(metadata.getId()), Integer.valueOf(ApiUtils.getUserSession(request.getSession()).getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)oldGroup, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject(group.get(), (String)"owner")).publish((ApplicationContext)appContext);
    }

    @Operation(summary="Get record sharing settings", description="")
    @RequestMapping(value={"/sharing"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Return a default array of group and operations that can be used to set record sharing properties."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public SharingResponse getSharingSettings(@Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        UserSession userSession = ApiUtils.getUserSession(session);
        SharingResponse sharingResponse = new SharingResponse();
        sharingResponse.setOwner(userSession.getUserId());
        List allOperations = this.operationRepository.findAll();
        Set userGroups = this.accessManager.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
        List elGroup = this.groupRepository.findAll();
        ArrayList<GroupPrivilege> groupPrivileges = new ArrayList<GroupPrivilege>(elGroup.size());
        String network = this.sm.getValue("system/intranet/network");
        boolean hasNetworkConfig = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)network);
        for (Group g : elGroup) {
            if (!hasNetworkConfig && g.getId() == ReservedGroup.intranet.getId()) continue;
            GroupPrivilege groupPrivilege = new GroupPrivilege();
            groupPrivilege.setGroup(g.getId());
            groupPrivilege.setReserved(g.isReserved());
            groupPrivilege.setUserGroup(userGroups.contains(g.getId()));
            HashMap<String, Boolean> operations = new HashMap<String, Boolean>(allOperations.size());
            for (org.fao.geonet.domain.Operation o : allOperations) {
                operations.put(o.getName(), false);
            }
            groupPrivilege.setOperations(operations);
            groupPrivileges.add(groupPrivilege);
        }
        sharingResponse.setPrivileges(groupPrivileges);
        return sharingResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set group and owner for one or more records", description="")
    @RequestMapping(value={"/ownership"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Records group and owner updated"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public MetadataProcessingReport setGroupAndOwner(@Parameter(description="Record UUIDs. If null current selection is used.", required=false) @RequestParam(required=false) String[] uuids, @Parameter(description="Group identifier", required=true) @RequestParam(required=true) Integer groupIdentifier, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="User identifier", required=true) @RequestParam(required=true) Integer userIdentifier, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="false") Boolean approved, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            for (String uuid : records) {
                this.updateOwnership(groupIdentifier, userIdentifier, report, this.dataManager, this.accessManager, serviceContext, listOfUpdatedRecords, uuid, session);
            }
            this.metadataManager.flush();
            this.metadataIndexer.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set record group and owner", description="")
    @RequestMapping(value={"/{metadataUuid}/ownership"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Record group and owner updated"), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ResponseBody
    public MetadataProcessingReport setRecordOwnership(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="Group identifier", required=true) @RequestParam(required=true) Integer groupIdentifier, @Parameter(description="User identifier", required=true) @RequestParam(required=true) Integer userIdentifier, @Parameter(description="Use approved version or not", example="true") @RequestParam(required=false, defaultValue="true") Boolean approved, @Parameter(hidden=true) HttpSession session, HttpServletRequest request) throws Exception {
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        ApiUtils.canEditRecord(metadataUuid, request);
        try {
            report.setTotalRecords(1);
            ServiceContext serviceContext = ApiUtils.createServiceContext(request);
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            this.updateOwnership(groupIdentifier, userIdentifier, report, this.dataManager, this.accessManager, serviceContext, listOfUpdatedRecords, metadataUuid, session);
            this.metadataManager.flush();
            this.metadataIndexer.indexMetadata(listOfUpdatedRecords);
        }
        catch (Exception exception) {
            report.addError(exception);
        }
        finally {
            report.close();
        }
        return report;
    }

    private void updateOwnership(Integer groupIdentifier, Integer userIdentifier, MetadataProcessingReport report, DataManager dataManager, AccessManager accessMan, ServiceContext serviceContext, List<String> listOfUpdatedRecords, String uuid, HttpSession session) throws Exception {
        AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
        if (metadata == null) {
            report.incrementNullRecords();
        } else if (!accessMan.canEdit(serviceContext, String.valueOf(metadata.getId()))) {
            report.addNotEditableMetadataId(metadata.getId());
        } else {
            List idList = this.metadataUtils.findAllIdsBy(MetadataSpecs.hasMetadataUuid((String)uuid));
            if (idList.size() > 1) {
                report.setTotalRecords(report.getNumberOfRecords() + 1);
            }
            for (Integer mdId : idList) {
                if (mdId.intValue() != metadata.getId()) {
                    metadata = this.metadataUtils.findOne(mdId.intValue());
                }
                Integer sourceUsr = metadata.getSourceInfo().getOwner();
                Integer sourceGrp = metadata.getSourceInfo().getGroupOwner();
                Vector<OperationAllowedId> sourcePriv = MetadataSharingApi.retrievePrivileges(serviceContext, String.valueOf(metadata.getId()), sourceUsr, sourceGrp);
                Integer groupIdentifierUsed = groupIdentifier;
                if (ReservedGroup.isReserved((int)groupIdentifier)) {
                    groupIdentifierUsed = sourceGrp;
                    report.addMetadataInfos(metadata, String.format("Reserved group '%s' on metadata '%s' is not allowed. Group owner will not be changed.", groupIdentifier, metadata.getUuid()));
                }
                if (sourcePriv.isEmpty()) {
                    dataManager.copyDefaultPrivForGroup(serviceContext, String.valueOf(metadata.getId()), String.valueOf(groupIdentifierUsed), false);
                    report.addMetadataInfos(metadata, String.format("No privileges for user '%s' on metadata '%s', so setting default privileges", sourceUsr, metadata.getUuid()));
                } else {
                    for (OperationAllowedId priv : sourcePriv) {
                        if (sourceGrp != null) {
                            dataManager.unsetOperation(serviceContext, metadata.getId(), sourceGrp.intValue(), priv.getOperationId());
                        }
                        dataManager.setOperation(serviceContext, metadata.getId(), groupIdentifierUsed.intValue(), priv.getOperationId());
                    }
                }
                Long metadataId = metadata.getId();
                ConfigurableApplicationContext context = ApplicationContextHolder.get();
                if (!Objects.equals(groupIdentifierUsed, sourceGrp)) {
                    Group newGroup = (Group)this.groupRepository.findById((Object)groupIdentifierUsed).get();
                    Group oldGroup = sourceGrp == null ? null : (Group)this.groupRepository.findById((Object)sourceGrp).get();
                    new RecordGroupOwnerChangeEvent(metadataId, Integer.valueOf(ApiUtils.getUserSession(session).getUserIdAsInt()), sourceGrp == null ? null : ObjectJSONUtils.convertObjectInJsonObject((Object)oldGroup, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject((Object)newGroup, (String)"owner")).publish((ApplicationContext)context);
                }
                if (!Objects.equals(userIdentifier, sourceUsr)) {
                    User newOwner = (User)this.userRepository.findById((Object)userIdentifier).get();
                    User oldOwner = (User)this.userRepository.findById((Object)sourceUsr).get();
                    new RecordOwnerChangeEvent(metadataId, Integer.valueOf(ApiUtils.getUserSession(session).getUserIdAsInt()), ObjectJSONUtils.convertObjectInJsonObject((Object)oldOwner, (String)"owner"), ObjectJSONUtils.convertObjectInJsonObject((Object)newOwner, (String)"owner")).publish((ApplicationContext)context);
                }
                dataManager.updateMetadataOwner(metadata.getId(), String.valueOf(userIdentifier), String.valueOf(groupIdentifierUsed));
                report.addMetadataId(metadata.getId());
                report.incrementProcessedRecords();
                listOfUpdatedRecords.add("" + metadata.getId());
            }
        }
    }

    private void checkCanPublishToAllGroup(ServiceContext context, ResourceBundle messages, AbstractMetadata metadata, boolean allowPublishInvalidMd, boolean allowPublishNonApprovedMd) throws Exception {
        String statusId;
        boolean isApproved;
        MetadataStatus metadataStatusValue;
        if (!allowPublishInvalidMd) {
            boolean isInvalid;
            boolean hasValidation;
            boolean bl = hasValidation = this.metadataValidationRepository.count(MetadataValidationSpecs.hasMetadataId((int)metadata.getId())) > 0L;
            if (!hasValidation) {
                this.validator.doValidate(metadata, context.getLanguage());
                this.metadataIndexer.indexMetadata("" + metadata.getId(), true, IndexingMode.full);
            }
            boolean bl2 = isInvalid = this.metadataValidationRepository.count(MetadataValidationSpecs.isInvalidAndRequiredForMetadata((int)metadata.getId())) > 0L;
            if (isInvalid) {
                throw new Exception(String.format(messages.getString("api.metadata.share.errorMetadataNotValid"), metadata.getUuid()));
            }
        }
        if (!allowPublishNonApprovedMd && (metadataStatusValue = this.metadataStatus.getStatus(metadata.getId())) != null && !(isApproved = (statusId = "" + metadataStatusValue.getStatusValue().getId()).equals("2"))) {
            throw new Exception(String.format(messages.getString("api.metadata.share.errorMetadataNotApproved"), metadata.getUuid()));
        }
    }

    private void shareMetadataWithReservedGroup(String metadataUuid, boolean publish, String publicationType, HttpSession session, HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext context = ApiUtils.createServiceContext(request);
        ResourceBundle messages = ApiUtils.getMessagesResourceBundle(request.getLocales());
        Locale[] feedbackLocales = this.feedbackLanguages.getLocales(request.getLocale());
        if (!this.accessManager.hasReviewPermission(context, Integer.toString(metadata.getId()))) {
            throw new Exception(String.format(messages.getString("api.metadata.share.ErrorUserNotAllowedToPublish"), metadataUuid, messages.getString(this.accessManager.getReviewerRule())));
        }
        List operationList = this.operationRepository.findAll();
        HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
        for (org.fao.geonet.domain.Operation o : operationList) {
            operationMap.put(o.getName(), o.getId());
        }
        SharingParameter sharing = this.buildSharingForPublicationConfig(publish, publicationType);
        List<GroupOperations> privileges = sharing.getPrivileges();
        ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
        boolean notifyByEmail = org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.sm.getValue("system/metadataprivs/publication/notificationLevel")});
        this.setOperations(sharing, this.dataManager, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), true, null, request, metadataListToNotifyPublication, notifyByEmail);
        this.metadataIndexer.indexMetadata(String.valueOf(metadata.getId()), true, IndexingMode.full);
        Optional<PublicationOption> publicationOption = this.publicationConfig.getPublicationOptionConfiguration(publicationType);
        if (publicationOption.isPresent() && publicationOption.get().hasPublicationTo(ReservedGroup.all) && notifyByEmail && !metadataListToNotifyPublication.isEmpty()) {
            this.metadataPublicationMailNotifier.notifyPublication(feedbackLocales, metadataListToNotifyPublication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetadataProcessingReport shareSelection(String[] uuids, String bucket, SharingParameter sharing, HttpSession session, HttpServletRequest request) throws Exception {
        try (SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();){
            Set<String> records = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, ApiUtils.getUserSession(session));
            report.setTotalRecords(records.size());
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            ServiceContext context = ApiUtils.createServiceContext(request);
            Locale[] feedbackLocales = this.feedbackLanguages.getLocales(request.getLocale());
            ArrayList<String> listOfUpdatedRecords = new ArrayList<String>();
            ArrayList<MetadataPublicationNotificationInfo> metadataListToNotifyPublication = new ArrayList<MetadataPublicationNotificationInfo>();
            boolean notifyByEmail = org.apache.commons.lang3.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.sm.getValue("system/metadataprivs/publication/notificationLevel")});
            for (String uuid : records) {
                AbstractMetadata metadata = this.metadataUtils.findOneByUuid(uuid);
                if (metadata == null) {
                    report.incrementNullRecords();
                    continue;
                }
                if (!this.accessManager.canEdit(ApiUtils.createServiceContext(request), String.valueOf(metadata.getId()))) {
                    report.addNotEditableMetadataId(metadata.getId());
                    continue;
                }
                boolean skipAllReservedGroup = false;
                if (!this.accessManager.hasReviewPermission(context, Integer.toString(metadata.getId()))) {
                    skipAllReservedGroup = true;
                }
                List operationList = this.operationRepository.findAll();
                HashMap<String, Integer> operationMap = new HashMap<String, Integer>(operationList.size());
                for (org.fao.geonet.domain.Operation o : operationList) {
                    operationMap.put(o.getName(), o.getId());
                }
                List<GroupOperations> privileges = sharing.getPrivileges();
                ArrayList<GroupOperations> allGroupPrivileges = new ArrayList<GroupOperations>();
                try {
                    if (metadata instanceof MetadataDraft) {
                        Metadata md = this.metadataRepository.findOneByUuid(metadata.getUuid());
                        if (md != null) {
                            this.setOperations(sharing, this.dataManager, context, (ApplicationContext)appContext, (AbstractMetadata)md, operationMap, allGroupPrivileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, report, request, metadataListToNotifyPublication, notifyByEmail);
                            report.incrementProcessedRecords();
                            listOfUpdatedRecords.add(String.valueOf(md.getId()));
                            report.addMetadataId(metadata.getId());
                            continue;
                        }
                        this.setOperations(sharing, this.dataManager, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, report, request, metadataListToNotifyPublication, notifyByEmail);
                        report.incrementProcessedRecords();
                        listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
                        report.addMetadataId(metadata.getId());
                        continue;
                    }
                    this.setOperations(sharing, this.dataManager, context, (ApplicationContext)appContext, metadata, operationMap, privileges, ApiUtils.getUserSession(session).getUserIdAsInt(), skipAllReservedGroup, report, request, metadataListToNotifyPublication, notifyByEmail);
                    report.incrementProcessedRecords();
                    listOfUpdatedRecords.add(String.valueOf(metadata.getId()));
                    report.addMetadataId(metadata.getId());
                }
                catch (NotAllowedException ex) {
                    report.addMetadataError(metadata, ex.getMessage());
                    report.incrementUnchangedRecords();
                }
            }
            if (!metadataListToNotifyPublication.isEmpty()) {
                this.metadataPublicationMailNotifier.notifyPublication(feedbackLocales, metadataListToNotifyPublication);
            }
            this.metadataManager.flush();
            this.metadataIndexer.indexMetadata(listOfUpdatedRecords);
        }
        return report;
    }

    private SharingParameter buildSharingForPublicationConfig(boolean publish, String configName) {
        SharingParameter sharing = new SharingParameter();
        sharing.setClear(false);
        ArrayList<GroupOperations> privilegesList = new ArrayList<GroupOperations>();
        Optional<PublicationOption> publicationOptionOptional = this.publicationConfig.getPublicationOptionConfiguration(configName);
        if (publicationOptionOptional.isPresent()) {
            PublicationOption publicationOption = publicationOptionOptional.get();
            Iterator<ReservedOperation> it = publicationOption.getPublicationOperations().iterator();
            GroupOperations privReservedGroup = new GroupOperations();
            privReservedGroup.setGroup(publicationOption.getPublicationGroup().getId());
            HashMap<String, Boolean> operations = new HashMap<String, Boolean>();
            while (it.hasNext()) {
                ReservedOperation operation = it.next();
                operations.put(operation.toString(), publish);
            }
            privReservedGroup.setOperations(operations);
            privilegesList.add(privReservedGroup);
            for (Map.Entry<ReservedGroup, List<ReservedOperation>> info : publicationOption.getAdditionalPublications().entrySet()) {
                privReservedGroup = new GroupOperations();
                privReservedGroup.setGroup(info.getKey().getId());
                operations = new HashMap();
                for (ReservedOperation operation : info.getValue()) {
                    operations.put(operation.toString(), publish);
                }
                privReservedGroup.setOperations(operations);
                privilegesList.add(privReservedGroup);
            }
        }
        sharing.setPrivileges(privilegesList);
        return sharing;
    }

    private void checkChangesAllowedToUserProfileForReservedGroups(UserSession userSession, SharingResponse originalPrivileges, List<GroupOperations> newPrivileges, boolean merge) {
        if (userSession.getProfile() == Profile.Administrator) {
            return;
        }
        List<PrivilegeStatusChange> privilegeStatusChangesList = this.reservedGroupsPrivilegesStatusChanges(originalPrivileges, newPrivileges, merge);
        if (!privilegeStatusChangesList.isEmpty()) {
            boolean metadataWasPublishedBeforeAndNotAfter = false;
            boolean metadataWasNotPublishedBeforeAndIsAfter = false;
            for (PrivilegeStatusChange status : privilegeStatusChangesList) {
                if (status.isPublishedBefore() && !status.isPublishedAfter()) {
                    metadataWasPublishedBeforeAndNotAfter = true;
                    continue;
                }
                if (status.isPublishedBefore() || !status.isPublishedAfter()) continue;
                metadataWasNotPublishedBeforeAndIsAfter = true;
            }
            if (metadataWasPublishedBeforeAndNotAfter) {
                this.checkUserProfileToUnpublishMetadata(userSession);
            }
            if (metadataWasNotPublishedBeforeAndIsAfter) {
                this.checkUserProfileToPublishMetadata(userSession);
            }
        }
    }

    private void checkUserProfileToPublishMetadata(UserSession userSession) {
        String allowedUserProfileToPublishMetadata;
        if (userSession.getProfile() != Profile.Administrator && !UserUtil.hasHierarchyRole((String)(allowedUserProfileToPublishMetadata = StringUtils.defaultIfBlank((String)this.sm.getValue("metadata/publication/profilePublishMetadata"), (String)Profile.Reviewer.toString())), (RoleHierarchy)this.roleHierarchy)) {
            throw new NotAllowedException(String.format("Publication of metadata is not allowed. User needs to be at least %s to publish record.", allowedUserProfileToPublishMetadata));
        }
    }

    private void checkUserProfileToUnpublishMetadata(UserSession userSession) {
        String allowedUserProfileToUnpublishMetadata;
        if (userSession.getProfile() != Profile.Administrator && !UserUtil.hasHierarchyRole((String)(allowedUserProfileToUnpublishMetadata = StringUtils.defaultIfBlank((String)this.sm.getValue("metadata/publication/profileUnpublishMetadata"), (String)Profile.Reviewer.toString())), (RoleHierarchy)this.roleHierarchy)) {
            throw new NotAllowedException(String.format("Unpublication of metadata is not allowed. User needs to be at least %s to unpublish record.", allowedUserProfileToUnpublishMetadata));
        }
    }

    private boolean canUserChangePrivilegesForGroup(ServiceContext context, Group group) {
        Profile minimumProfileForPrivileges = group.getMinimumProfileForPrivileges();
        if (minimumProfileForPrivileges == null) {
            return true;
        }
        return this.accessManager.isProfileOrMoreOnGroup(context, minimumProfileForPrivileges, group.getId());
    }

    public List<PrivilegeStatusChange> reservedGroupsPrivilegesStatusChanges(SharingResponse sharingBefore, List<GroupOperations> newPrivileges, boolean merge) {
        ArrayList<PrivilegeStatusChange> privilegeStatuses = new ArrayList<PrivilegeStatusChange>();
        for (GroupPrivilege g : sharingBefore.getPrivileges()) {
            if (!g.isReserved()) continue;
            ReservedGroup group = Arrays.stream(ReservedGroup.values()).filter(rg -> rg.getId() == g.getGroup().intValue()).findFirst().get();
            Map<Object, Object> operationsAllGroupAfter = new HashMap();
            Optional<GroupOperations> groupPrivilegeAllGroupAfter = newPrivileges.stream().filter(gp -> group.getId() == gp.getGroup().intValue()).findFirst();
            if (groupPrivilegeAllGroupAfter.isPresent()) {
                operationsAllGroupAfter = groupPrivilegeAllGroupAfter.get().getOperations();
            }
            for (Map.Entry<String, Boolean> op : g.getOperations().entrySet()) {
                PrivilegeStatusChange privilegeStatus = new PrivilegeStatusChange();
                privilegeStatus.setGroup(group);
                privilegeStatus.setPublishedBefore(g.getOperations().getOrDefault(op.getKey(), Boolean.FALSE));
                privilegeStatus.setPublishedAfter(operationsAllGroupAfter.getOrDefault(op.getKey(), merge ? privilegeStatus.publishedBefore : Boolean.FALSE));
                privilegeStatus.setOperation(op.getKey());
                privilegeStatuses.add(privilegeStatus);
            }
        }
        return privilegeStatuses.stream().filter(p -> p.publishedBefore != p.publishedAfter).collect(Collectors.toList());
    }

    private class PrivilegeStatusChange {
        private boolean publishedBefore;
        private boolean publishedAfter;
        private ReservedGroup group;
        private String operation;

        private PrivilegeStatusChange() {
        }

        public boolean isPublishedBefore() {
            return this.publishedBefore;
        }

        public void setPublishedBefore(boolean publishedBefore) {
            this.publishedBefore = publishedBefore;
        }

        public boolean isPublishedAfter() {
            return this.publishedAfter;
        }

        public void setPublishedAfter(boolean publishedAfter) {
            this.publishedAfter = publishedAfter;
        }

        public ReservedGroup getGroup() {
            return this.group;
        }

        public void setGroup(ReservedGroup group) {
            this.group = group;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }
    }
}

