/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.es;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Constants;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.es.JsonStreamUtils;
import org.fao.geonet.api.records.MetadataUtils;
import org.fao.geonet.api.records.model.related.AssociatedRecord;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.index.es.EsRestClient;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.SelectionManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.MetadataSchemaOperationFilter;
import org.fao.geonet.kernel.search.EsFilterBuilder;
import org.fao.geonet.repository.SourceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api"})
@Tag(name="search", description="Proxy for Elasticsearch catalog search operations")
@Controller
public class EsHTTPProxy {
    public static final String[] _validContentTypes = new String[]{"application/json", "text/plain"};
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.index");
    private static final String filterTemplate = " {\n       \t\"query_string\": {\n       \t\t\"query\": \"%s\"\n       \t}\n}";
    private static final String SEARCH_ENDPOINT = "_search";
    private static final String MULTISEARCH_ENDPOINT = "_msearch";
    @Autowired
    AccessManager accessManager;
    @Autowired
    NodeInfo node;
    @Autowired
    SourceRepository sourceRepository;
    @Value(value="${es.index.records:gn-records}")
    private String defaultIndex;
    @Value(value="${es.username}")
    private String username;
    @Value(value="${es.password}")
    private String password;
    @Value(value="${es.proxy.headers:content-type,content-encoding,transfer-encoding}")
    private String[] proxyHeadersAllowedList;
    private String[] proxyHeadersIgnoreList = new String[]{"Content-Length"};
    @Autowired
    private EsRestClient client;
    @Autowired
    private SchemaManager schemaManager;

    private static Integer getInteger(ObjectNode node, String name) {
        JsonNode sub = node.get(name);
        return sub != null ? Integer.valueOf(sub.asInt()) : null;
    }

    private static String getString(ObjectNode node, String name) {
        JsonNode sub = node.get(name);
        return sub != null ? sub.asText() : null;
    }

    private static String getSourceString(ObjectNode node, String name) {
        JsonNode sub = node.get("_source").get(name);
        return sub != null ? sub.asText() : null;
    }

    private static Integer getSourceInteger(ObjectNode node, String name) {
        JsonNode sub = node.get("_source").get(name);
        return sub != null ? Integer.valueOf(sub.asInt()) : null;
    }

    private static void addSelectionInfo(ObjectNode doc, Set<String> selections) {
        String uuid = EsHTTPProxy.getSourceString(doc, "uuid");
        doc.put("selected", selections.contains(uuid));
    }

    private static void addRelatedTypes(ObjectNode doc, RelatedItemType[] relatedTypes, ServiceContext context) {
        Map<RelatedItemType, List<AssociatedRecord>> related = null;
        try {
            related = MetadataUtils.getAssociated(context, ((IMetadataUtils)context.getBean(IMetadataUtils.class)).findOne(doc.get("_source").get("id").asText()), relatedTypes, 0, 1000);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load related types for {}. Error is: {}", (Object)EsHTTPProxy.getSourceString(doc, "uuid"), (Object)e.getMessage());
        }
        doc.putPOJO("related", related);
    }

    public static void addUserInfo(ObjectNode doc, ServiceContext context) throws Exception {
        HashSet operations;
        Integer owner = EsHTTPProxy.getSourceInteger(doc, "owner");
        Integer groupOwner = EsHTTPProxy.getSourceInteger(doc, "groupOwner");
        String id = EsHTTPProxy.getSourceString(doc, "id");
        ObjectMapper objectMapper = new ObjectMapper();
        MetadataSourceInfo sourceInfo = new MetadataSourceInfo();
        sourceInfo.setOwner(owner);
        if (groupOwner != null) {
            sourceInfo.setGroupOwner(groupOwner);
        }
        AccessManager accessManager = (AccessManager)context.getBean(AccessManager.class);
        boolean isOwner = accessManager.isOwner(context, sourceInfo);
        boolean canEdit = false;
        if (isOwner) {
            operations = Sets.newHashSet(Arrays.asList(ReservedOperation.values()));
            if (owner != null) {
                doc.put("ownerId", owner.intValue());
            }
        } else {
            Set groups = accessManager.getUserGroups(context.getUserSession(), context.getIpAddress(), false);
            Set editingGroups = accessManager.getUserGroups(context.getUserSession(), context.getIpAddress(), true);
            operations = Sets.newHashSet();
            for (ReservedOperation operation : ReservedOperation.values()) {
                ArrayNode opFields;
                JsonNode operationNodes = doc.get("_source").get("op" + operation.getId());
                if (operationNodes == null) continue;
                ArrayNode arrayNode = opFields = operationNodes.isArray() ? (ArrayNode)operationNodes : objectMapper.createArrayNode().add(operationNodes);
                if (opFields == null) continue;
                for (JsonNode field : opFields) {
                    int groupId = field.asInt();
                    if (operation == ReservedOperation.editing && !canEdit && editingGroups.contains(groupId)) {
                        canEdit = true;
                    }
                    if (!groups.contains(groupId)) continue;
                    operations.add(operation);
                }
            }
        }
        doc.put("edit", isOwner || canEdit);
        doc.put("canReview", id != null ? accessManager.hasReviewPermission(context, id) : false);
        doc.put("owner", isOwner);
        doc.put("isPublishedToAll", EsHTTPProxy.hasOperation(doc, ReservedGroup.all, ReservedOperation.view));
        EsHTTPProxy.addReservedOperation(doc, operations, ReservedOperation.view);
        EsHTTPProxy.addReservedOperation(doc, operations, ReservedOperation.notify);
        EsHTTPProxy.addReservedOperation(doc, operations, ReservedOperation.download);
        EsHTTPProxy.addReservedOperation(doc, operations, ReservedOperation.dynamic);
        EsHTTPProxy.addReservedOperation(doc, operations, ReservedOperation.featured);
        if (!operations.contains(ReservedOperation.download)) {
            doc.put("guestdownload", EsHTTPProxy.hasOperation(doc, ReservedGroup.guest, ReservedOperation.download));
        }
    }

    private static void addReservedOperation(ObjectNode doc, HashSet<ReservedOperation> operations, ReservedOperation kind) {
        doc.put(kind.name(), operations.contains(kind));
    }

    private static boolean hasOperation(ObjectNode doc, ReservedGroup group, ReservedOperation operation) {
        ObjectMapper objectMapper = new ObjectMapper();
        int groupId = group.getId();
        JsonNode operationNodes = doc.get("_source").get("op" + operation.getId());
        if (operationNodes != null) {
            ArrayNode opFields;
            ArrayNode arrayNode = opFields = operationNodes.isArray() ? (ArrayNode)operationNodes : objectMapper.createArrayNode().add(operationNodes);
            if (opFields != null) {
                for (JsonNode field : opFields) {
                    if (groupId != field.asInt()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Operation(summary="Execute a search query and get back search hits that match the query.", description="The search API execute a search query with a JSON request body. For more information see https://www.elastic.co/guide/en/elasticsearch/reference/current/search-search.html for search parameters, and https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html JSON Query DSL.")
    @RequestMapping(value={"/search/records/_search"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Search results.", content={@Content(mediaType="application/json", schema=@Schema(type="string"))})})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void search(@RequestParam(defaultValue="s101") String bucket, @Parameter(description="Type of related resource. If none, no associated resource returned.", required=false) @RequestParam(name="relatedType", defaultValue="") RelatedItemType[] relatedTypes, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response, @org.springframework.web.bind.annotation.RequestBody @RequestBody(description="JSON request based on Elasticsearch API.", content={@Content(examples={@ExampleObject(value="{\"query\":{\"match\":{\"_id\":\"catalogue_uuid\"}}}")})}) String body) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.call(context, httpSession, request, response, SEARCH_ENDPOINT, body, bucket, relatedTypes);
    }

    @Operation(summary="Executes several searches with a Elasticsearch API request.", description="The multi search API executes several searches from a single API request. See https://www.elastic.co/guide/en/elasticsearch/reference/current/search-multi-search.html for search parameters, and https://www.elastic.co/guide/en/elasticsearch/reference/current/query-dsl.html Query DSL.")
    @RequestMapping(value={"/search/records/_msearch"}, method={RequestMethod.POST}, produces={"application/json", "application/x-ndjson"}, consumes={"application/json", "application/x-ndjson"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Search results.", content={@Content(mediaType="application/json", schema=@Schema(type="string")), @Content(mediaType="application/x-ndjson", schema=@Schema(type="string"))})})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void msearch(@RequestParam(defaultValue="metadata") String bucket, @Parameter(description="Type of related resource. If none, no associated resource returned.", required=false) @RequestParam(name="relatedType", defaultValue="") RelatedItemType[] relatedTypes, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response, @org.springframework.web.bind.annotation.RequestBody @RequestBody(description="JSON request based on Elasticsearch API.", content={@Content(examples={@ExampleObject(value="{\"query\":{\"match\":{\"_id\":\"catalogue_uuid\"}}}")})}) String body) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.call(context, httpSession, request, response, MULTISEARCH_ENDPOINT, body, bucket, relatedTypes);
    }

    @Hidden
    @Operation(summary="Elasticsearch proxy endpoint", description="Endpoint to allow access to more ES API only allowed to Administrator. Currently not used by the user interface. Needs improvements in the proxy call.")
    @RequestMapping(value={"/search/records/{endPoint}"}, method={RequestMethod.POST, RequestMethod.GET}, produces={"application/json"}, consumes={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Search results.", content={@Content(mediaType="application/json", schema=@Schema(type="string"))})})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseBody
    public void call(@RequestParam(defaultValue="s101") String bucket, @Parameter(description="'_search' for search service.") @PathVariable String endPoint, @Parameter(hidden=true) HttpSession httpSession, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpServletResponse response, @org.springframework.web.bind.annotation.RequestBody @RequestBody(description="JSON request based on Elasticsearch API.", content={@Content(examples={@ExampleObject(value="{\"query\":{\"match\":{\"_id\":\"catalogue_uuid\"}}}")})}) String body) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        this.call(context, httpSession, request, response, endPoint, body, bucket, null);
    }

    private void call(ServiceContext context, HttpSession httpSession, HttpServletRequest request, HttpServletResponse response, String endPoint, String body, String selectionBucket, RelatedItemType[] relatedTypes) throws Exception {
        String url = this.client.getServerUrl() + "/" + this.defaultIndex + "/" + endPoint + "?";
        if (SEARCH_ENDPOINT.equals(endPoint) || MULTISEARCH_ENDPOINT.equals(endPoint)) {
            UserSession session = context.getUserSession();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode nodeQuery = objectMapper.readTree(body);
            MappingIterator mappingIterator = objectMapper.readerFor(JsonNode.class).readValues(body);
            StringBuffer requestBody = new StringBuffer();
            while (mappingIterator.hasNextValue()) {
                JsonNode node = (JsonNode)mappingIterator.nextValue();
                JsonNode indexNode = node.get("index");
                if (indexNode != null) {
                    ((ObjectNode)node).put("index", this.defaultIndex);
                } else {
                    JsonNode sourceNode;
                    JsonNode queryNode = node.get("query");
                    if (queryNode != null) {
                        this.addFilterToQuery(context, objectMapper, node);
                        if (selectionBucket != null) {
                            session.setProperty("search.request" + selectionBucket, (Object)node);
                        }
                    }
                    if ((sourceNode = node.get("_source")) != null) {
                        if (sourceNode.isArray()) {
                            this.addRequiredField((ArrayNode)sourceNode);
                        } else {
                            JsonNode sourceIncludes = sourceNode.get("includes");
                            if (sourceIncludes != null && sourceIncludes.isArray()) {
                                this.addRequiredField((ArrayNode)sourceIncludes);
                            }
                        }
                    }
                }
                requestBody.append(node).append(System.lineSeparator());
            }
            this.handleRequest(context, httpSession, request, response, url, endPoint, requestBody.toString(), true, selectionBucket, relatedTypes);
        } else {
            this.handleRequest(context, httpSession, request, response, url, endPoint, body, true, selectionBucket, relatedTypes);
        }
    }

    private void addRequiredField(ArrayNode source) {
        source.add("op*");
        source.add("documentStandard");
        source.add("groupOwner");
        source.add("owner");
        source.add("id");
    }

    private void addFilterToQuery(ServiceContext context, ObjectMapper objectMapper, JsonNode esQuery) throws Exception {
        String esFilter = this.buildQueryFilter(context, "", esQuery.toString().contains("\"draft\":") || esQuery.toString().contains("+draft:") || esQuery.toString().contains("-draft:"));
        JsonNode nodeFilter = objectMapper.readTree(esFilter);
        JsonNode queryNode = esQuery.get("query");
        if (queryNode.get("function_score") != null) {
            ObjectNode objectNode = (ObjectNode)queryNode.get("function_score").get("query").get("bool");
            this.insertFilter(objectNode, nodeFilter);
        } else if (queryNode.get("bool") != null) {
            ObjectNode objectNode = (ObjectNode)queryNode.get("bool");
            this.insertFilter(objectNode, nodeFilter);
        } else {
            ObjectNode copy = (ObjectNode)esQuery.get("query").deepCopy();
            ObjectNode objectNodeBool = objectMapper.createObjectNode();
            objectNodeBool.set("must", (JsonNode)copy);
            objectNodeBool.set("filter", nodeFilter);
            ((ObjectNode)queryNode).removeAll();
            ((ObjectNode)queryNode).set("bool", (JsonNode)objectNodeBool);
        }
    }

    private void insertFilter(ObjectNode objectNode, JsonNode nodeFilter) {
        JsonNode filter = objectNode.get("filter");
        if (filter != null && filter.isArray()) {
            ((ArrayNode)filter).add(nodeFilter);
        } else {
            objectNode.set("filter", nodeFilter);
        }
    }

    private String buildQueryFilter(ServiceContext context, String type, boolean isSearchingForDraft) throws Exception {
        return String.format(filterTemplate, EsFilterBuilder.build((ServiceContext)context, (String)type, (boolean)isSearchingForDraft, (NodeInfo)this.node));
    }

    private String buildDocTypeFilter(String type) {
        return "documentType:" + type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ServiceContext context, HttpSession httpSession, HttpServletRequest request, HttpServletResponse response, String sUrl, String endPoint, String requestBody, boolean addPermissions, String selectionBucket, RelatedItemType[] relatedTypes) throws Exception {
        try {
            URL url = new URL(sUrl);
            HttpURLConnection connectionWithFinalHost = (HttpURLConnection)url.openConnection();
            try {
                Object streamToClient;
                InputStream streamFromServer;
                connectionWithFinalHost.setRequestMethod(request.getMethod());
                this.copyHeadersToConnection(request, connectionWithFinalHost);
                if (StringUtils.isNotEmpty((String)this.username) && StringUtils.isNotEmpty((String)this.password)) {
                    String auth = this.username + ":" + this.password;
                    byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
                    String authHeaderValue = "Basic " + new String(encodedAuth);
                    connectionWithFinalHost.setRequestProperty("Authorization", authHeaderValue);
                }
                connectionWithFinalHost.setDoOutput(true);
                connectionWithFinalHost.getOutputStream().write(requestBody.getBytes(Constants.ENCODING));
                connectionWithFinalHost.connect();
                String contentEncoding = this.getContentEncoding(connectionWithFinalHost.getHeaderFields());
                int code = connectionWithFinalHost.getResponseCode();
                if (code != 200) {
                    InputStream errorDetails = "gzip".equalsIgnoreCase(contentEncoding) ? new GZIPInputStream(connectionWithFinalHost.getErrorStream()) : connectionWithFinalHost.getErrorStream();
                    response.sendError(code, String.format("Error is: %s.\nRequest:\n%s.\nError:\n%s.", connectionWithFinalHost.getResponseMessage(), requestBody, IOUtils.toString((InputStream)errorDetails)));
                    return;
                }
                String contentType = connectionWithFinalHost.getContentType();
                if (contentType == null) {
                    response.sendError(403, "Host url has been validated by proxy but content type given by remote host is null");
                    return;
                }
                if (!this.isContentTypeValid(contentType)) {
                    if (connectionWithFinalHost.getResponseMessage() != null && connectionWithFinalHost.getResponseMessage().equalsIgnoreCase("Not Found")) {
                        response.sendError(404, "Remote host not found");
                        return;
                    }
                    response.sendError(403, "The content type of the remote host's response \"" + contentType + "\" is not allowed by the proxy rules");
                    return;
                }
                this.copyHeadersFromConnectionToResponse(response, connectionWithFinalHost, this.proxyHeadersIgnoreList);
                if (!contentType.split(";")[0].equals("application/json")) {
                    addPermissions = false;
                }
                if (contentEncoding == null || !addPermissions) {
                    streamFromServer = connectionWithFinalHost.getInputStream();
                    streamToClient = response.getOutputStream();
                } else if ("gzip".equalsIgnoreCase(contentEncoding)) {
                    streamFromServer = new GZIPInputStream(connectionWithFinalHost.getInputStream());
                    streamToClient = new GZIPOutputStream((OutputStream)response.getOutputStream());
                } else if ("deflate".equalsIgnoreCase(contentEncoding)) {
                    streamFromServer = new DeflaterInputStream(connectionWithFinalHost.getInputStream());
                    streamToClient = new DeflaterOutputStream((OutputStream)response.getOutputStream());
                } else {
                    throw new UnsupportedOperationException("Please handle the stream when it is encoded in " + contentEncoding);
                }
                try {
                    this.processResponse(context, httpSession, streamFromServer, (OutputStream)streamToClient, endPoint, selectionBucket, addPermissions, relatedTypes);
                    ((OutputStream)streamToClient).flush();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)streamFromServer);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                connectionWithFinalHost.disconnect();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception(String.format("Failed to request Es at URL %s. Check Es configuration.", sUrl), e);
        }
    }

    private void processResponse(ServiceContext context, HttpSession httpSession, InputStream streamFromServer, OutputStream streamToClient, String endPoint, String bucket, boolean addPermissions, RelatedItemType[] relatedTypes) throws Exception {
        HashSet selections;
        JsonParser parser = JsonStreamUtils.jsonFactory.createParser(streamFromServer);
        JsonGenerator generator = JsonStreamUtils.jsonFactory.createGenerator(streamToClient);
        parser.nextToken();
        Set set = selections = addPermissions ? SelectionManager.getManager((UserSession)ApiUtils.getUserSession(httpSession)).getSelection(bucket) : new HashSet();
        if (endPoint.equals(SEARCH_ENDPOINT)) {
            JsonStreamUtils.addInfoToDocs(parser, generator, doc -> {
                if (addPermissions) {
                    EsHTTPProxy.addUserInfo(doc, context);
                    EsHTTPProxy.addSelectionInfo(doc, selections);
                }
                if (relatedTypes != null && relatedTypes.length > 0) {
                    EsHTTPProxy.addRelatedTypes(doc, relatedTypes, context);
                }
                if (doc.has("_source")) {
                    ObjectNode sourceNode = (ObjectNode)doc.get("_source");
                    if (sourceNode.has("documentStandard")) {
                        String metadataSchema = sourceNode.get("documentStandard").asText();
                        try {
                            MetadataSchema mds = this.schemaManager.getSchema(metadataSchema);
                            this.processMetadataSchemaFilters(context, mds, doc);
                        }
                        catch (IllegalArgumentException e) {
                            LOGGER.error("Failed to load metadata schema for {}. Error is: {}", (Object)EsHTTPProxy.getSourceString(doc, "uuid"), (Object)e.getMessage());
                        }
                    }
                    for (ReservedOperation o : ReservedOperation.values()) {
                        sourceNode.remove("op" + o.getId());
                    }
                }
            });
        } else {
            JsonStreamUtils.addInfoToDocsMSearch(parser, generator, doc -> {
                if (addPermissions) {
                    EsHTTPProxy.addUserInfo(doc, context);
                    EsHTTPProxy.addSelectionInfo(doc, selections);
                }
                if (relatedTypes != null && relatedTypes.length > 0) {
                    EsHTTPProxy.addRelatedTypes(doc, relatedTypes, context);
                }
                if (doc.has("_source")) {
                    ObjectNode sourceNode = (ObjectNode)doc.get("_source");
                    for (ReservedOperation o : ReservedOperation.values()) {
                        sourceNode.remove("op" + o.getId());
                    }
                }
            });
        }
        generator.flush();
        generator.close();
    }

    private String getContentEncoding(Map<String, List<String>> headerFields) {
        for (String headerName : headerFields.keySet()) {
            if (headerName == null || !"Content-Encoding".equalsIgnoreCase(headerName)) continue;
            List<String> valuesList = headerFields.get(headerName);
            StringBuilder sBuilder = new StringBuilder();
            valuesList.forEach(sBuilder::append);
            return sBuilder.toString().toLowerCase();
        }
        return null;
    }

    private void copyHeadersFromConnectionToResponse(HttpServletResponse response, HttpURLConnection uc, String ... ignoreList) {
        Map<String, List<String>> map = uc.getHeaderFields();
        for (String headerName : map.keySet()) {
            if (headerName == null || Arrays.stream(ignoreList).anyMatch(headerName::equalsIgnoreCase) || Arrays.stream(this.proxyHeadersAllowedList).noneMatch(headerName::equalsIgnoreCase)) continue;
            List<String> valuesList = map.get(headerName);
            StringBuilder sBuilder = new StringBuilder();
            valuesList.forEach(sBuilder::append);
            if ("Transfer-Encoding".equalsIgnoreCase(headerName) && "chunked".equalsIgnoreCase(sBuilder.toString())) continue;
            response.addHeader(headerName, sBuilder.toString());
        }
    }

    protected void copyHeadersToConnection(HttpServletRequest request, HttpURLConnection uc) {
        Enumeration enumHeader = request.getHeaderNames();
        while (enumHeader.hasMoreElements()) {
            String headerName = (String)enumHeader.nextElement();
            String headerValue = request.getHeader(headerName);
            if ("host".equalsIgnoreCase(headerName) || "X-XSRF-TOKEN".equalsIgnoreCase(headerName) || "Cookie".equalsIgnoreCase(headerName)) continue;
            uc.setRequestProperty(headerName, headerValue);
        }
    }

    protected boolean isContentTypeValid(String contentType) {
        String type = contentType.split(";")[0];
        for (String validTypeContent : _validContentTypes) {
            if (!validTypeContent.equals(type)) continue;
            return true;
        }
        return false;
    }

    private void processMetadataSchemaFilters(ServiceContext context, MetadataSchema mds, ObjectNode doc) throws JsonProcessingException {
        JsonNode actualObj;
        boolean canDynamic;
        MetadataSchemaOperationFilter dynamicFilter;
        boolean canDownload;
        MetadataSchemaOperationFilter downloadFilter;
        boolean canEdit;
        MetadataSchemaOperationFilter editFilter;
        if (!doc.has("_source")) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode sourceNode = (ObjectNode)doc.get("_source");
        MetadataSchemaOperationFilter authenticatedFilter = mds.getOperationFilter("authenticated");
        ArrayList<String> jsonpathFilters = new ArrayList<String>();
        if (authenticatedFilter != null && !context.getUserSession().isAuthenticated()) {
            jsonpathFilters.add(authenticatedFilter.getJsonpath());
        }
        if ((editFilter = mds.getOperationFilter(ReservedOperation.editing)) != null && !(canEdit = doc.get("edit").asBoolean())) {
            jsonpathFilters.add(editFilter.getJsonpath());
        }
        if ((downloadFilter = mds.getOperationFilter(ReservedOperation.download)) != null && !(canDownload = doc.get("download").asBoolean())) {
            jsonpathFilters.add(downloadFilter.getJsonpath());
        }
        if ((dynamicFilter = mds.getOperationFilter(ReservedOperation.dynamic)) != null && !(canDynamic = doc.get("dynamic").asBoolean())) {
            jsonpathFilters.add(dynamicFilter.getJsonpath());
        }
        if ((actualObj = this.filterResponseElements(mapper, sourceNode, jsonpathFilters)) != null) {
            doc.set("_source", actualObj);
        }
    }

    private JsonNode filterResponseElements(ObjectMapper mapper, ObjectNode sourceNode, List<String> jsonPathFilters) throws JsonProcessingException {
        DocumentContext jsonContext = JsonPath.parse((String)sourceNode.toPrettyString());
        for (String jsonPath : jsonPathFilters) {
            if (!StringUtils.isNotBlank((String)jsonPath)) continue;
            try {
                jsonContext = jsonContext.delete(jsonPath, new Predicate[0]);
            }
            catch (PathNotFoundException pathNotFoundException) {}
        }
        return mapper.readTree(jsonContext.jsonString());
    }
}

