/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.schema.impl;

import java.net.URI;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;

public class ChoiceGT
implements Choice {
    private String id;
    private int min;
    private int max;
    private ElementGrouping[] children;

    private ChoiceGT() {
    }

    public ChoiceGT(String id, int min, int max, ElementGrouping[] children) {
        this.id = id;
        this.min = min;
        this.max = max;
        this.children = children;
    }

    public ChoiceGT(ElementGrouping[] children) {
        this.min = 1;
        this.max = 1;
        this.children = children;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxOccurs() {
        return this.max;
    }

    @Override
    public int getMinOccurs() {
        return this.min;
    }

    @Override
    public ElementGrouping[] getChildren() {
        return this.children;
    }

    @Override
    public int getGrouping() {
        return 16;
    }

    @Override
    public Element findChildElement(String name) {
        if (this.children == null) {
            return null;
        }
        for (ElementGrouping child : this.children) {
            Element e = child.findChildElement(name);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public Element findChildElement(String localName, URI namespaceURI) {
        if (this.children == null) {
            return null;
        }
        for (ElementGrouping child : this.children) {
            Element e = child.findChildElement(localName, namespaceURI);
            if (e == null) continue;
            return e;
        }
        return null;
    }
}

