/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.fao.geonet.utils.Log;

public class ThreadPool {
    public static final String SEQUENTIAL_EXECUTION = "geonetwork.sequential.execution";
    final ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue(20);
    int poolSize = 5;
    int maxPoolSize = 10;
    long keepAliveTime = 2L;
    ThreadPoolExecutor threadPool = null;
    ScheduledExecutorService timer = Executors.newScheduledThreadPool(1);

    public ThreadPool() {
        this.threadPool = new ThreadPoolExecutor(this.poolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, this.queue, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void runTask(Runnable task) {
        this.runTask(task, 0, TimeUnit.SECONDS);
    }

    public void runTask(Runnable task, int delayBeforeStart, TimeUnit unit) {
        if (Boolean.parseBoolean(System.getProperty(SEQUENTIAL_EXECUTION, "false"))) {
            task.run();
        } else if (delayBeforeStart < 1) {
            if (Log.isDebugEnabled((String)"geonetwork.threadpool")) {
                Log.debug((String)"geonetwork.threadpool", (Object)("Adding task to threadpool:" + this.toString()));
            }
            this.threadPool.execute(task);
        } else {
            if (Log.isDebugEnabled((String)"geonetwork.threadpool")) {
                Log.debug((String)"geonetwork.threadpool", (Object)("Scheduling task to be executed in threadpool in " + delayBeforeStart + " " + unit + ": " + this.toString()));
            }
            this.timer.schedule(new ScheduledTask(task), (long)delayBeforeStart, unit);
        }
    }

    @PreDestroy
    public void shutDown() {
        Log.info((String)"geonetwork.threadpool", (Object)"Stopping the ThreadPool");
        this.threadPool.shutdown();
        try {
            this.threadPool.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Log.warning((String)"geonetwork.threadpool", (Object)"Error while stopping threadPool", (Throwable)e);
        }
        this.timer.shutdown();
        try {
            this.timer.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Log.warning((String)"geonetwork.threadpool", (Object)"Error while stopping threadPool", (Throwable)e);
        }
        Log.info((String)"geonetwork.threadpool", (Object)"Stopped the ThreadPool");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ThreadPool tasks | ");
        sb.append(" \t| total: ").append(this.threadPool.getTaskCount());
        sb.append(" \t| completed: ").append(this.threadPool.getCompletedTaskCount());
        sb.append(" \t| active: ").append(this.threadPool.getActiveCount());
        sb.append(" \t| in queue: ").append(this.queue.size());
        sb.append(" \t| remaining in queue: ").append(this.queue.remainingCapacity());
        return sb.toString();
    }

    private class ScheduledTask
    implements Runnable {
        private final Runnable task;

        public ScheduledTask(Runnable task) {
            this.task = task;
        }

        @Override
        public void run() {
            ThreadPool.this.threadPool.execute(this.task);
            if (Log.isDebugEnabled((String)"geonetwork.threadpool")) {
                Log.debug((String)"geonetwork.threadpool", (Object)("Adding task to threadpool after being scheduled: " + this.toString()));
            }
        }
    }
}

