/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.ldap;

import java.util.LinkedList;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.User;
import org.fao.geonet.events.user.GroupLeft;
import org.fao.geonet.kernel.security.ldap.AbstractLDAPUserDetailsContextMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.security.ldap.LdapUtils;

public class AutoUpdateUserGroupsOnRemove
implements ApplicationListener<GroupLeft> {
    @Autowired
    private AbstractLDAPUserDetailsContextMapper ldapMapper;
    private LdapTemplate template;
    private String baseDn = "ou=groups";
    private String groupAttribute = "cn";
    private Boolean withProfiles = true;
    private String profilePattern = "{0}_{1}";
    private Map<String, String> profileMapping;

    public void onApplicationEvent(GroupLeft event) {
        Group group = event.getUserGroup().getGroup();
        User user = event.getUserGroup().getUser();
        String identifier = group.getName();
        String username = user.getUsername();
        String p = event.getUserGroup().getProfile().name();
        if (!this.withProfiles.booleanValue()) {
            this.saveUserGroup(identifier, username);
        } else {
            String profile = this.profileMapping.containsKey(p) ? this.profileMapping.get(p) : p;
            String id = this.profilePattern;
            id = id.replace("{0}", profile);
            id = id.replace("{1}", identifier);
            this.saveUserGroup(id, username);
        }
    }

    private void saveUserGroup(String identifier, String username) {
        DirContextAdapter group = this.getGroup(identifier);
        if (group != null) {
            String[] memberuids = group.getStringAttributes("memberUid");
            if (memberuids == null) {
                memberuids = new String[]{};
            }
            LinkedList<String> members = new LinkedList<String>();
            for (int i = 0; i < memberuids.length; ++i) {
                if (memberuids[i].equalsIgnoreCase(username)) continue;
                members.add(memberuids[i]);
            }
            Object[] newmemberuids = new String[memberuids.length - 1];
            newmemberuids = members.toArray(newmemberuids);
            group.setAttributeValues("memberUid", newmemberuids);
            this.template.modifyAttributes((DirContextOperations)group);
            LdapUtils.closeContext((Context)group);
        }
    }

    public DistinguishedName buildDn(String s) {
        DistinguishedName dn = new DistinguishedName(this.baseDn);
        dn.add(this.groupAttribute, s);
        return dn;
    }

    public DirContextAdapter getGroup(String group) {
        DistinguishedName dn = this.buildDn(group);
        try {
            Object obj = this.template.lookup((Name)dn);
            if (obj instanceof DirContextAdapter) {
                return (DirContextAdapter)obj;
            }
            return null;
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    public void setLdapMapper(AbstractLDAPUserDetailsContextMapper ldapMapper) {
        this.ldapMapper = ldapMapper;
    }

    public void setTemplate(LdapTemplate template) {
        this.template = template;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public void setGroupAttribute(String groupAttribute) {
        this.groupAttribute = groupAttribute;
    }

    public void setWithProfiles(Boolean withProfiles) {
        this.withProfiles = withProfiles;
    }

    public void setProfilePattern(String profilePattern) {
        this.profilePattern = profilePattern;
    }

    public void setContextSource(ContextSource contextSource) {
        this.template = new LdapTemplate(contextSource);
    }

    public void setProfileMapping(Map<String, String> profileMapping) {
        this.profileMapping = profileMapping;
    }
}

