/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map;

import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.style.Style;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.map.StyleLayer;

public abstract class RasterLayer
extends StyleLayer {
    protected SimpleFeatureSource source;

    public RasterLayer(Style style) {
        super(style);
    }

    public RasterLayer(Style style, String title) {
        super(style, title);
    }

    public synchronized SimpleFeatureSource getFeatureSource() {
        if (this.source == null) {
            if (this.getUserData().containsKey("source")) {
                return null;
            }
            SimpleFeatureCollection featureCollection = this.toFeatureCollection();
            if (featureCollection != null) {
                this.source = DataUtilities.source(featureCollection);
            }
            this.getUserData().put("source", this.source);
        }
        return this.source;
    }

    @Override
    public void dispose() {
        if (this.source != null) {
            this.getUserData().remove("source");
            this.source = null;
        }
        super.dispose();
    }

    public abstract SimpleFeatureCollection toFeatureCollection();
}

