/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.jwtheaders.roles;

import com.nimbusds.jose.JWSObject;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import org.geoserver.security.jwtheaders.JwtConfiguration;
import org.geoserver.security.jwtheaders.roles.RoleConverter;
import org.geoserver.security.jwtheaders.username.JwtHeaderUserNameExtractor;

public class JwtHeadersRolesExtractor {
    JwtConfiguration jwtHeadersConfig;
    RoleConverter roleConverter;

    public JwtHeadersRolesExtractor(JwtConfiguration config) {
        this.jwtHeadersConfig = config;
        this.roleConverter = new RoleConverter(config);
    }

    public Collection<String> getRoles(String headerValue) {
        if (headerValue == null || headerValue.isBlank()) {
            return null;
        }
        headerValue = headerValue.replaceFirst("^Bearer", "");
        headerValue = headerValue.replaceFirst("^bearer", "");
        headerValue = headerValue.trim();
        if (this.jwtHeadersConfig.getJwtHeaderRoleSource().equals(JwtConfiguration.JWTHeaderRoleSource.JWT.toString())) {
            JWSObject jwsObject = null;
            try {
                jwsObject = JWSObject.parse((String)headerValue);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            Map claims = jwsObject.getPayload().toJSONObject();
            List<String> roleNames = JwtHeadersRolesExtractor.asStringList(JwtHeaderUserNameExtractor.getClaim((Map<String, Object>)claims, this.jwtHeadersConfig.getRolesJsonPath()));
            List<String> roles = this.roleConverter.convert(roleNames);
            return roles;
        }
        if (this.jwtHeadersConfig.getJwtHeaderRoleSource().equals(JwtConfiguration.JWTHeaderRoleSource.JSON.toString())) {
            List<String> roleNames = JwtHeadersRolesExtractor.asStringList(JwtHeaderUserNameExtractor.extractFromJSON(headerValue, this.jwtHeadersConfig.getRolesJsonPath()));
            List<String> roles = this.roleConverter.convert(roleNames);
            return roles;
        }
        return null;
    }

    public static List<String> asStringList(Object obj) {
        if (obj instanceof String) {
            return Arrays.asList((String)obj);
        }
        if (obj instanceof JSONArray) {
            return ((JSONArray)obj).stream().map(x -> x.toString()).collect(Collectors.toList());
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return list.stream().map(x -> x.toString()).collect(Collectors.toList());
        }
        return null;
    }
}

