/*
 * Decompiled with CFR 0.152.
 */
package org.w3._2001.smil20;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CalcModeType implements Enumerator
{
    DISCRETE(0, "discrete", "discrete"),
    LINEAR(1, "linear", "linear"),
    PACED(2, "paced", "paced");

    public static final int DISCRETE_VALUE = 0;
    public static final int LINEAR_VALUE = 1;
    public static final int PACED_VALUE = 2;
    private static final CalcModeType[] VALUES_ARRAY;
    public static final List<CalcModeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static CalcModeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CalcModeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static CalcModeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            CalcModeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static CalcModeType get(int value) {
        switch (value) {
            case 0: {
                return DISCRETE;
            }
            case 1: {
                return LINEAR;
            }
            case 2: {
                return PACED;
            }
        }
        return null;
    }

    private CalcModeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new CalcModeType[]{DISCRETE, LINEAR, PACED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

