/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.oidc;

import java.net.URL;
import java.time.Instant;
import java.util.List;
import org.springframework.security.oauth2.core.oidc.StandardClaimAccessor;

public interface IdTokenClaimAccessor
extends StandardClaimAccessor {
    default public URL getIssuer() {
        return this.getClaimAsURL("iss");
    }

    @Override
    default public String getSubject() {
        return this.getClaimAsString("sub");
    }

    default public List<String> getAudience() {
        return this.getClaimAsStringList("aud");
    }

    default public Instant getExpiresAt() {
        return this.getClaimAsInstant("exp");
    }

    default public Instant getIssuedAt() {
        return this.getClaimAsInstant("iat");
    }

    default public Instant getAuthenticatedAt() {
        return this.getClaimAsInstant("auth_time");
    }

    default public String getNonce() {
        return this.getClaimAsString("nonce");
    }

    default public String getAuthenticationContextClass() {
        return this.getClaimAsString("acr");
    }

    default public List<String> getAuthenticationMethods() {
        return this.getClaimAsStringList("amr");
    }

    default public String getAuthorizedParty() {
        return this.getClaimAsString("azp");
    }

    default public String getAccessTokenHash() {
        return this.getClaimAsString("at_hash");
    }

    default public String getAuthorizationCodeHash() {
        return this.getClaimAsString("c_hash");
    }
}

